#include <module.h>
inherit "module";
inherit "caudiumlib";
#include <camas/screens.h>	// For screennames
#include <camas/msg.h>		// MSG() Language macros
#include <camas/globals.h>	// Global definitions
#include <camas/pmods.h>        // Local or normal camas pike modules
#include <camas/addressbook.h> // Address book defines and translations

inherit camas_tags;

// ============================================================================
//  FILES screen container handler
// ============================================================================
//!  Files screen call for CAMAS
//! returns:
//!  Function called when Files handling is needed.
//!  Return RXML code with correct replacements from defvars and
//!  values from CAMAS internals
string screen(mapping args, string contents, object id)
{
  string out = "";
  CSESSION->screen = "files";	// Admin screen name
  
  mapping tags_handlers =
    ([
      "camas_deleteselectedfiles": tag_camas_deleteselectedfiles_buttons,
      "camas_availablespace"     : tag_camas_availablespace,
    ]);
  
  mapping containers_handlers = 
    ([
      "camas_filelist"      : container_camas_filelist,
      "camas_uploadfiles"   : container_camas_uploadfiles2,
    ]);
  
  contents = CAMAS.Parse.parse_html(contents, tags_handlers, containers_handlers, id);

  if(!id->misc->_xml_parser && QUERY(ent_parse))
    contents = parse_scopes(contents,cb_scopes,id);

  args->method = "post";
  args->name = "camasfilesform";

  args = CAMAS.Tools.set_target(id, args);

  out += CAMAS.Tools.make_container("form", args, contents);

  return out;
}

//! tag: camas_deleteselectedfiles
//!  Button delete marked files
string tag_camas_deleteselectedfiles_buttons(string tag_name, mapping args, object id)
{
  if (sizeof (CSESSION->files))
    return CAMAS.Tools.formdrawbutton(id,"m_deletemarkedfiles", "actiondeletefiles", MSG(M_DELETEMARKEDFILES), args);
  else
    return "";
}

//! tag: camas_availablespace
//!   Display the place available for file upload if user has quotas
string tag_camas_availablespace(string tag_name, mapping args, object id)
{
  int totsize = 0;
  string out = "";
  object camas_main = CAMAS_MODULE;
  int uploadquota = camas_main->QUERY(uploadquota);
  
  if(CSESSION->files)
    foreach (CSESSION->files, mapping file)
      totsize += file->size;
    
  if (uploadquota) {
    int space = (((uploadquota*1024) - totsize) / 1024);
    out += MSGA(M_AVAILSPACE, ({ space }));
    if (space <= 0)
      out = "";
  }
  return out;
}

//! container: camas_uploadfiles2
//!  Zone for button and stuff with files to upload in files screen
//! childtag : filepath
//! childtag : addthisfile
string container_camas_uploadfiles2(string tag_name, mapping args, string contents,object id)
{
  string out = "";
  
  out += "</form>";

  args -> name  = "imhouploadform";
  args -> target= id->misc->camas->target;
  args -> method= "post";
  args -> enctype ="multipart/form-data";
  args -> action= id->misc->camas->nexttarget;

  contents = CAMAS.Parse.parse_html(contents,
                    ([
                     "camas_filepath"                       : tag_camas_uploadfiles2_subtags,
                     "camas_addthisfile"                    : tag_camas_uploadfiles2_subtags,
                     ]),
                    ([
                     ]),
                    id);

  out += CAMAS.Tools.make_container("form", args, contents);

  out += "<form target=\"" + id->misc->camas->target;
  out += "\" method=\"post\" action=\"" + id->misc->camas->nexttarget + "\">";

  return out;
}

/* code for tags included in the camas_uploadfiles container */
string tag_camas_uploadfiles2_subtags(string tag_name, mapping args, object id)
{
  string out = "";

  switch(tag_name)
  {
  case "camas_filepath":
    //! tag: camas_filepath
    //! parentcontainer : camas_uploadfiles2
    //!  Path of the file to add to attachments
    //! note: screen: attachments
    args -> name = "file";
    args -> type = "file";
    
    out += CAMAS.Tools.make_tag("input", args);
    break;

  case "camas_addthisfile":
    //! tag: camas_addthisfile
    //! parentcontainer : camas_uploadfiles2
    //!  Button for adding all selected item to attachments list
    //! note: screen: attachments
    mapping hiddenargs = ([ ]);
    hiddenargs->type = "hidden";
    if (id->supports->javascript)
    {
      hiddenargs->name = "fixedfilename";
      hiddenargs->value= "";
      out += CAMAS.Tools.make_tag("input", hiddenargs);
    }
    else
    {
      out += MSG(M_WINDOWSBUG);
    }

    hiddenargs->name = "actionupload";
    hiddenargs->value= "1";
    out += CAMAS.Tools.make_tag("input", hiddenargs);
    args->onclick="document.forms.imhouploadform.fixedfilename.value=document.forms.imhouploadform.file.value.replace(/\\\\/g,'\\\\\\\\')";

    out += CAMAS.Tools.formdrawbutton(id,"m_upload", "1", MSG(M_UPLOAD), args);
    break;

  default:
    out += "<!-- container_uploadfiles2_subtags: " + tag_name + " is not supported yet -->";
    CDEBUG("<!-- container_uploadfiles2_subtags: " + tag_name + " is not supported yet -->");
  }

  return out;
}

string container_camas_filelist(string tag_name, mapping args, string contents,object id)
{
  string out = "";
  
  if (sizeof (CSESSION->files))
  {
    out += "<form method=\"post\" action=\"" + id->misc->camas->nextpage + "\"";
    out += " " + CAMAS.Tools.make_tag_attributes(args) + " >";
    out += CAMAS.Parse.parse_html(contents,
                    ([
                     ]),
                    ([
            		"camas_title"                       : container_camas_files_filelist_title,
                    	"camas_contents"                    : container_camas_files_filelist_contents,
                     ]),
                    id);
   
  }
  else
    out += MSG(M_NOFILES);
  return out;
}

string container_camas_files_filelist_title(string tag_name, mapping args, string contents,object id)
{
  array rxmlvariables =
    ({
      ([
        "mark"       : MSG(M_MARKFLAG),
        "filename"   : MSG(M_FILENAME),
      	"size"	     : MSG(M_SIZE),
        "type"       : MSG(M_MIMETYPE),
      ])
    });
  
  contents = do_output_tag(args, rxmlvariables, contents, id);
  
  return contents;
 
}

string container_camas_files_filelist_contents(string tag_name, mapping args, string contents,object id)
{
  string out = "";
  int i = 0;
  foreach (CSESSION->files, mapping file) {    
    array rxmlvariables = 
    ({
       ([ 
         "mark"		: "<input type=\"checkbox\" name=\"file" + (string)i+ "\" value=\"1\" " + CAMAS.Tools.make_tag_attributes(args) + " />",
	 "filename"	: "<a href=\"" + id->misc->camas->nextpage + "-" + CAMAS.Tools.rand_string(20, id->supports->ssl_faulty) +
	 			file->fname + "?download=" + (string)i+ "\" " + CAMAS.Tools.make_tag_attributes(args) + ">" +
				file->fname + "</a>",
	 "size"		: file->size,
	 "type"		: file->type,
       ])
    });
    out += do_output_tag(args, rxmlvariables, contents, id);
    i++;
  }
  return out;
}
/*                                                                             
 * Local Variables:                                                            
 * c-basic-offset: 2                                                           
 * End:                                                                        
 *                                                                             
 * vim: softtabstop=2 tabstop=2 expandtab autoindent formatoptions=croqlt smartindent cindent shiftwidth=2
 */
