#include <module.h>
inherit "module";
inherit "caudiumlib";
#include <camas/screens.h>	// For screennames
#include <camas/msg.h>		// MSG() Language macros
#include <camas/globals.h>	// Global definitions
#include <camas/pmods.h>        // Local or normal camas pike modules
#include <camas/addressbook.h> // Address book defines and translations

inherit camas_tags;

object parser = camas_tags->cache_parse_html();

void set_sorting(object id)
{
  // sorting management
  if(sizeof(CSESSION->addrbook_contents))
  {
    array(mapping) contacts = CSESSION->addrbook_contents;
    // the table for the table sort module
    array(array) table_content = allocate(sizeof(contacts), ({ }));
    array(string) column_names = ({ });
 
    for (int i = 0; i < sizeof(contacts); i++)
    {
      mapping(int:array(string)) contact  = contacts[i];
      for(int j = 1; j <= NB_AD_DEFINES; j++)
      {
         string value = "";
        if(contact[j] && arrayp(contact[j]))
          value = contact[j] * ",";
        value = CAMAS.Tools.fix_header(value);
        table_content[i] += ({ value });
        if(i == 0) 
        {
          column_names += ({ search(ldapattributes2input, j) });
        }
      }
    }
    id->conf->get_provider("tabsort")->set_table(id, table_content,
      column_names, search(ldapattributes2input, AD_NAME));
  }
}

// ============================================================================
//  ADDRESSBOOK screen container handler
// ============================================================================
string screen(mapping args, string contents, object id)
{
  string out = "";
  array addressbooks = id->conf->get_providers("camas_addressbook");
  if(sizeof(addressbooks) == 0)
    return "<!-- You must load at least one addressbook module to have this screen -->";
  CSESSION->screen = "addressbook";	// Admin screen name
  set_sorting(id);

  contents = CAMAS.Parse.parse_html(contents,
                        ([
                         "camas_backtocompose"        : tag_camas_addressbook,
                         "camas_newaddress"           : tag_camas_addressbook,
                         "camas_importaddressbook"    : tag_camas_addressbook,
                         "camas_deletealladdressbook" : tag_camas_addressbook,
                         "camas_select_selectaddressbook": tag_camas_select_addressbook,
                         "camas_input_selectaddressbook": tag_camas_addressbook,   
                         "camas_input_search"         : tag_camas_addressbook,
                         "camas_submit_search"        : tag_camas_addressbook,
                         "camas_addrecipient"         : tag_camas_addressbook,
                         "camas_deleteaddress"        : tag_camas_addressbook,
                         ]),
                        ([
                         "camas_addresslist"          : container_camas_addresslist,
                         "camas_fromcompose"          : container_camas_fromcompose,
                         "camas_notfromcompose"       : container_camas_notfromcompose,
                         ]),
                        id);

  if (!id -> misc -> _xml_parser && QUERY (ent_parse))
    contents = parse_scopes (contents, cb_scopes, id);

  args -> method = "post";
  args -> name = "camasaddressbookform";

  args = CAMAS . Tools . set_target (id, args);

  out += CAMAS . Tools . make_container ("form", args, contents);

  return out;
}

/* code for most addressbook screen tags */
string tag_camas_addressbook(string tag_name, mapping args, object id)
{
  object camas_features = id->conf->get_provider ("camas_features");
  if (!objectp(camas_features))
  {
    CDEBUG("module camas_features is not present");
    return "foobar";
  }

  string out = "<!-- Beginning of " + tag_name + "-->";
  int size=((args->size) ? args->size : 20);
  int writeable = 0;
  if(CAMAS.AddressBook2.get_currentaddrbook(id)->writeable())
    writeable = 1;

  switch(tag_name)
  {
  case "camas_backtocompose":
    //! tag: camas_backtocompose
    //!  Button to go back to compose screen
    //! note: screen: addressbook, addressbooktoccbcc
    if (CSESSION->recipientfield)
      out = CAMAS.Tools.formdrawbutton(id, "m_backtocompose", "actioncontinuecompose", MSG(M_BACKTOCOMPOSE), args);
    else
      out = "<!-- Not from compose screen : do not display back to compose -->\n";
    break;

  case "camas_newaddress":
    //! tag: camas_newaddress
    //!  Button to add a new address in addressbook
    //! note: screen: addressbook, addressbooktoccbcc
    if(writeable)
      out = CAMAS.Tools.formdrawbutton(id, "m_newaddress", "actionnewaddress2", MSG(M_NEWADDRESS)+"...", args);
    else
      out = "<!-- user is not allowed to edit this addressbook : not writeable -->\n";
    break;

  case "camas_importaddressbook":
    //! tag: camas_importaddressbook
    //!  Button to import existing addressbook
    //! note: screen: addressbook, addressbooktoccbcc
    if(writeable)
      out = CAMAS.Tools.formdrawbutton(id,"m_importaddressbook", "actiongotoimportaddress", MSG(M_IMPORTADDRESSBOOK)+"...", args);
    else
      out = "<!-- user is not allowed to edit this addressbook : not writeable -->\n";
    break;

  case "camas_deletealladdressbook":
    //! tag: camas_deletealladdressbook
    //!  Button to delete all addressbook entries
    //! note: screen: addressbook, addressbooktoccbcc
    if(writeable)
      out = CAMAS.Tools.formdrawbutton(id,"m_deletealladdress", "actiondeletealladdress2", MSG(M_DELETEALLADDRESS), args);
    else
      out = "<!-- user is not allowed to edit this addressbook : not writeable -->\n";
    break;

  case "camas_addrecipient":
    //! tag: camas_addrecipient
    //!  Button to add the selected entries to compose fields
    //! note: screen: addressbook, addressbooktoccbcc
    if(writeable)
      out = CAMAS.Tools.formdrawbutton(id,"m_addrecipients", "actionaddrecipients", MSG(M_ADDRECIPIENTS), args);
    else
      out = "<!-- user is not allowed to edit this addressbook : not writeable -->\n";
    break;

  case "camas_deleteaddress":
    //! tag: camas_deleteaddress
    //!  Button to delete a contact from the given addressbook
    //! note: screen: addressbook, addressbooktoccbcc
    if(writeable)
      out = CAMAS.Tools.formdrawbutton(id, "m_deleterecipients", "actiondeleteaddress2", MSG(M_DELETEMARKED), args);
    else
      out = "<!-- user is not allowed to edit this addressbook : not writeable -->\n";
    break;
    
  case "camas_input_selectaddressbook":
    //! tag: camas_input_selectaddressbook
    //!  Submit change of addressbook
    //! note: screen: addressbook, addressbooktoccbcc
    out = CAMAS.Tools.formdrawbutton(id, "m_selectaddrbook", "actionaddressbookselect", MSG(M_SELECT), args);
    break;
    
  case "camas_input_search":
    //! tag: camas_input_search
    //!  Input for searching something in the addressbook
    //! note: screen: addressbook, addressbooktoccbcc
    args->name = "search";
    args->type = "text";
    out = CAMAS.Tools.make_tag("input", args);
    break;

  case "camas_submit_search":
    //! tag: camas_submit_search
    //!  Button for submitting search
    //! note: screen: addressbook, addressbooktoccbcc
    out = CAMAS.Tools.formdrawbutton(id, "m_searchaddrbook", "actionsearchaddrbook", MSG(M_SEARCHMAIL), args);
    break;

  default:
    out = "<!-- "+tag_name+" is not supported yet -->";
    CDEBUG(tag_name+" not supported");
  }
  out += "<!-- End of " + tag_name + "-->";
  return out;
}

//! container : camas_fromcompose
//!  Contents of container will be displayed if we come from the compose screen
//! note: screen: addressbook
string container_camas_fromcompose(string tag_name, mapping args, string contents,object id)
{
  string out = "<!-- Beginning of " + tag_name + "-->";
  if(CSESSION->recipientfield)
    out += contents;
  out += "<!-- End of " + tag_name + "-->";
  return out;
}

//! container : camas_notfromcompose
//!  Contents of container will be displayed if we do not come from the compose screen
//! note: screen: addressbook
string container_camas_notfromcompose(string tag_name, mapping args, string contents,object id)
{
  string out = "<!-- Beginning of " + tag_name + "-->";
  if(!CSESSION->recipientfield)
    out += contents;
  out += "<!-- End of " + tag_name + "-->";
  return out;
}

//! container : camas_addresslist
//!  Container for listing addressbook
//! childcontainer : camas_address
//! childcontainer : camas_noaddress
//! note: screen: addressbook
string container_camas_addresslist(string tag_name, mapping args, string contents,object id)
{
  string out = "<!-- Beginning of " + tag_name + "-->";   // HTML to output

  out += CAMAS.Parse.parse_html(contents,
                    ([
                     ]),
                    ([
                     "camas_address"    : container_camas_addresslist_address,
                     "camas_noaddress"  : container_camas_addresslist_noaddress,
                     ]),
                    id);
  out += "<!-- End of " + tag_name + "-->";
  return out;
}

//! subcontainer : camas_address
//!  Zone displayed when there is adress in the addressbook
//! parentcontainer : camas_addresslist
//! childcontainer : camas_allfields
//! childcontainer : camas_loopcontents
//! childcontainer : camas_selectedfields
//! note: screen: addressbook
string container_camas_addresslist_address(string tag_name, mapping args, string contents,object id)
{
  string out = "<!-- Beginning of " + tag_name + "-->";

  // <camas_address></> and <camas_noaddress></> are mutually exclusive
  if(sizeof(CSESSION->addrbook_contents))
  {
    CDEBUG("camas_address");

    out += parser->run(contents,
                      ([
                       ]),
                      ([
                       "camas_allfields"  : container_camas_addresslist_address_allfields,
                       "camas_selectedfields": container_camas_addresslist_address_selectedfields,
                       "camas_loopcontents" : container_camas_addresslist_address_loopcontents,
                       ]),
                      CSESSION->layout, __LINE__ + "/" + CAMAS.Tools.get_hash(contents), id);
  }

  out += "<!-- End of " + tag_name + "-->";
  return out;
}

//! subcontainer : camas_noaddress
//!  Zone to be displayed when there is no address in the addressbook
//! parentcontainer : camas_addresslist
//! note: screen: addressbook
string container_camas_addresslist_noaddress(string tag_name, mapping args, string contents,object id)
{
  string out = "<!-- Beginning of " + tag_name + "-->";
  array addressbooks = id->conf->get_providers("camas_addressbook");

  // <camas_address></> and <camas_noaddress></> are mutually exclusive
  if(!sizeof(CSESSION->addrbook_contents))
  {
    CDEBUG("camas_noaddress");
    object navbar = id->conf->get_provider("navbar");
    navbar->set_nb_elements(id, 0);
    out += contents;
  }
  out += "<!-- End of " + tag_name + "-->";
  return out;
}

//! subcontainer: camas_allfields
//! parentcontainer: camas_address
//! childcontainer: camas_loopcontents
//!  The contents of this container will be displayed when there is only one button in compose
//!  in order for the user to select destination field for the contact: To, CC or Bcc
string container_camas_addresslist_address_allfields(string tag_name, int pos, mapping args, string contents, object id)
{
  string out = "<!-- Beginning of " + tag_name + "-->";
  if(CSESSION->recipientfield == "toccbcc")
  {
    out += parser->run(contents,
                      ([
                       ]),
                      ([
                       "camas_loopcontents" : container_camas_addresslist_address_loopcontents,
                       ]),
                      CSESSION->layout, __LINE__ + "/" + pos, id);
  }
  out += "<!-- End of " + tag_name + "-->";
  return out;
}

//! subcontainer: camas_selectedfields
//! parentcontainer: camas_address
//! childcontainer: camas_loopcontents
//!  The contents of this container will be displayed when there is one button in compose for
//!  each field (To, CC and Bcc).
string container_camas_addresslist_address_selectedfields(string tag_name, int pos, mapping args, string contents, object id)
{
  string out = "<!-- Beginning of " + tag_name + "-->";
  if(CSESSION->recipientfield == "to" || CSESSION->recipientfield == "cc" 
      || CSESSION->recipientfield == "bcc")
  {
    out += parser->run(contents,
                      ([
                       ]),
                      ([
                       "camas_loopcontents" : container_camas_addresslist_address_loopcontents,
                       ]),
                      CSESSION->layout, __LINE__ + "/" + pos, id);
  }
  out += "<!-- End of " + tag_name + "-->";
  return out;
}

//! subcontainer : camas_loopcontents
//! parentcontainer : camas_address
//!  &lt;camas_loopcontents&gt;contents&lt;/camas_loopcontents&gt; is displayed for each addressbook entry
//! variable: camas_to
//! variable: camas_cc
//! variable: camas_bcc
//! variable: camas_cn
//! variable: camas_sn
//! variable: camas_givenName
//! variable: camas_homePhone
//! variable: camas_telephoneNumber
//! variable: camas_title
//! variable: camas_o
//! variable: camas_ou
//! variable: camas_homePostalAddress
//! variable: camas_postalAddress
//! variable: camas_l
//! variable: camas_st
//! variable: camas_c
//! variable: camas_pager
//! variable: camas_mobile
//! variable: camas_labeledURI
//! variable: camas_description
//! variable: camas_seeAlso
//! variable: camas_mail
//! variable: camas_postalCode
//! variable: camas_cn
//! variable: camas_mail
//! variable: camas_givenname
//! variable: camas_homephone
//! variable: camas_workphone
//! variable: camas_title
//! variable: camas_company
//! variable: camas_department
//! variable: camas_homepostaladdress
//! variable: camas_workpostaladdress
//! variable: camas_workcity
//! variable: camas_workstate
//! variable: camas_workcountry
//! variable: camas_pager,
//! variable: camas_mobile
//! variable: camas_workurl
//! variable: camas_homeurl
//! variable: camas_description
//! childcontainer : camas_href
//! arg: nonavbar
//!  Do not manage navigation bar
//! note: screen: addressbook
string container_camas_addresslist_address_loopcontents(string tag_name, int pos, mapping args, string contents, object id)
{
  string out = "<!-- Beginning of " + tag_name + "-->";
  object navbar = id->conf->get_provider("navbar");
  int currentid = 0;
  array(mapping) contacts = CSESSION->addrbook_contents;
  int start = 0;
  int end = sizeof(contacts)-1;
  // navigation bar management
  if(!args->nonavbar)
  {
    navbar->set_nb_elements(id, sizeof(contacts));
    navbar->set_nb_elements_per_page(id, (int)CSESSION->visiblemail);
    start = navbar->get_min_element(id);
    end = navbar->get_max_element(id);
  }
  array(array) sorted_table = id->conf->get_provider("tabsort")->get_table(id);

  for (int i = start; i <= end; i++)
  {
    string to_field      = "<input type=\"checkbox\" name=\"recipient_to_" +
                           currentid + "\">";
    string cc_field      = "<input type=\"checkbox\" name=\"recipient_cc_" +
                           currentid + "\">";
    string bcc_field     = "<input type=\"checkbox\" name=\"recipient_bcc_"
                           + currentid + "\">";
    // addressbooktoccbcc specific
    if(CSESSION->recipientfield == "toccbcc")
    {
      // we put this in every fields because the user may ommit one of them
      string hidden_addr = "<input type=\"hidden\" name=\"address_" + currentid +
        "\" value=\"" + sorted_table[i][AD_MAIL-1] + "\">";
      to_field += hidden_addr;
      cc_field += hidden_addr;
      bcc_field += hidden_addr;
    }

    mapping moutlet = ([ ]);
    foreach(indices(ldapattributes2input), string tagname)
    {
      tagname = lower_case(tagname);
      moutlet += ([ "camas_" + tagname : sorted_table[i][ldapattributes2input[tagname]-1] ]);
    }
    array outlet = ({
                      ([
                        "camas_to"                : to_field,
                        "camas_cc"                : cc_field,
                        "camas_bcc"               : bcc_field,
                       ])
                    });
    outlet[0] += moutlet;

    string contents2 = parser->run(contents,
                      ([
                         "camas_input_selectaddress": tag_camas_addresslist_address_loopcontents_input_selectaddress
                       ]),
                      ([
                         "camas_href"    : container_camas_addresslist_address_loopcontents_href,
                       ]),
                      CSESSION->layout, __LINE__ + "/" + pos, id, sorted_table[i][AD_MAIL-1]);

    out += do_output_tag(args, outlet, contents2, id);

    currentid++;
  } // foreach
  
  out += "<!-- End of " + tag_name + "-->";
  return out;
}

//! subtag: camas_input_selectaddress
//!  Widget for selecting contact in addressbook list
//! parentcontainer: camas_loopcontents
//! note: screen: ADDRESSBOOK
string tag_camas_addresslist_address_loopcontents_input_selectaddress(string tag_name, int pos, mapping args, object id, string currentaddress)
{
		args->type = "checkbox";
		args->name = "msg" + currentaddress;
		args->value = "1";

		return CAMAS.Tools.make_tag("input", args);
}

//! subcontainer : camas_href
//! parentcontainer : camas_loopcontents
//! attribute: action
//! note: screen: addressbook
string container_camas_addresslist_address_loopcontents_href(string tag_name, int pos, mapping args, string contents, object id, string currentaddress)
{
  string out = "<!-- Beginning of " + tag_name + "-->";
  mapping vars = ([ ]);

  object camas_features = id->conf->get_provider ("camas_features");
  if (!objectp(camas_features))
  {
    CDEBUG("module camas_features is not present");
    return "foobar";
  }

  switch(args->action)
  {
    case "addrecipient":
      if (CSESSION->recipientfield)
      {
        // TODO: put a multilingual alt="add this adress to recipient"
        vars = ([
          "actionaddrecipient" : "1",
          "address" : currentaddress,
        ]);
        args -> target = id->misc->camas->target;
        args -> alt  = "add";
        args -> href = CAMAS.Tools.make_get_url(id, args, vars);

      }
      else
        return contents;    
      break;

    case "edit":
      if(camas_features->feature(FEAT_EDITADDRESSBOOK))
      {
        // TODO: put a multilingual alt="edit this address"
        vars = ([
          "actioneditaddress2" : "1",
          "address" : currentaddress,
        ]);
        args -> target = id->misc->camas->target;
        args -> alt = "edit";
        args -> href = CAMAS.Tools.make_get_url(id, args, vars);
      }
      else
        return contents;
      break;

      // WARNING: this is buggy
    case "delete":
      if(camas_features->feature(FEAT_EDITADDRESSBOOK))
      {
        // TODO: put a multilingual alt="delete this address"
        vars = ([
    "actiondeleteaddress2" : "1",
    "address" : currentaddress,
        ]);
        args -> target = id->misc->camas->target;
        args -> alt  = "delete";
        args -> href = CAMAS.Tools.make_get_url(id, args, vars);
      }
      else
        return contents;
      break;
  }
  out += CAMAS.Tools.make_container("a",args,contents);
  out += "<!-- End of " + tag_name + "-->";
  return out;
}

/*                                                                             
 * Local Variables:                                                            
 * c-basic-offset: 2                                                           
 * End:                                                                        
 *                                                                             
 * vim: softtabstop=2 tabstop=2 expandtab autoindent formatoptions=croqlt smartindent cindent shiftwidth=2
 */
