#ifndef _POSITIONCURSOR_CPP_
#define _POSITIONCURSOR_CPP_

#include <iostream.h>
#include <qwidget.h>
#include <qpainter.h>

#include "positionCursor.h"


PositionCursor::PositionCursor(QWidget * win, int off) : _win(win), _offset(off), _mem(0) {

}

void PositionCursor::move(long pos, bool clear) {
  if (pos != _mem) {
    
    QPainter painter;
    painter.begin(_win);
    
    painter.setRasterOp(Qt::NotROP);
    if (clear && _mem != 0) painter.drawLine(_mem+_offset,0,_mem+_offset,640);
    if (pos != 0)  painter.drawLine(pos+_offset,0,pos+_offset,640);
    _mem = pos;
    painter.end();
  }
}


#endif
