/*=====================================================================*/
/*    serrano/prgm/project/bigloo/fthread/src/Posix/bglasync.c         */
/*    -------------------------------------------------------------    */
/*    Author      :  Manuel Serrano                                    */
/*    Creation    :  Mon Feb 25 18:13:15 2002                          */
/*    Last change :  Fri Nov 14 17:26:43 2003 (serrano)                */
/*    Copyright   :  2002-03 Manuel Serrano                            */
/*    -------------------------------------------------------------    */
/*    The implementation of asynchronous threads.                      */
/*=====================================================================*/
#include <pthread.h>
#include <stdlib.h>
#include <stdio.h>
#include <gc.h>

#define GC_PRIVATE_H
#include <bglthread.h>

extern char *strerror();

/*---------------------------------------------------------------------*/
/*    Global lock                                                      */
/*---------------------------------------------------------------------*/
extern pthread_key_t bglkey;

/*---------------------------------------------------------------------*/
/*    bglasync_t                                                       */
/*---------------------------------------------------------------------*/
typedef struct bglasync {
   obj_t thunk;
   obj_t id;
   bglthread_t scdl;
} *bglasync_t;

/*---------------------------------------------------------------------*/
/*    static void *                                                    */
/*    bglasync_run ...                                                 */
/*---------------------------------------------------------------------*/
static void *
bglasync_run( void *arg ) {
   bglasync_t th = (bglasync_t)arg;

   /* Mark the id for bmem (the first argument is ignored) */
   bglthread_id_set( (bglthread_t)th, th->id );

   /* run the asynchronous body */
   PROCEDURE_ENTRY( th->thunk )( th->thunk, BEOA );

   return 0L;
}

/*---------------------------------------------------------------------*/
/*    static bglthread_t                                               */
/*    bglasync_new ...                                                 */
/*---------------------------------------------------------------------*/
static bglasync_t
bglasync_new( bglthread_t scdl, obj_t proc, obj_t id ) {
   bglasync_t thread = (bglasync_t)GC_MALLOC( sizeof( struct bglasync ) );
   
   thread->thunk = proc;
   thread->id = id;
   thread->scdl = scdl;

   return thread;
}

/*---------------------------------------------------------------------*/
/*    void                                                             */
/*    bglasync_spawn ...                                               */
/*---------------------------------------------------------------------*/
void
bglasync_spawn( bglthread_t scdl, obj_t proc, obj_t id ) {
   bglasync_t async = bglasync_new( scdl, proc, id );
   pthread_attr_t a;
   pthread_t pthread;
   
   pthread_attr_init( &a );
   pthread_attr_setdetachstate( &a, PTHREAD_CREATE_DETACHED );

   if( pthread_create( &pthread, &a, bglasync_run, async ) )
      FAILURE( string_to_bstring( "bglasync-spawn" ),
	       string_to_bstring( "Cannot start thread" ),
	       string_to_bstring( strerror( errno ) ) );
}

/*---------------------------------------------------------------------*/
/*    void                                                             */
/*    bglasync_scheduler_wait ...                                      */
/*    -------------------------------------------------------------    */
/*    This function must always be called within the dynamic           */
/*    extent of a bglasync_synchronize                                 */
/*---------------------------------------------------------------------*/
void
bglasync_scheduler_wait( bglthread_t scdl ) {
   pthread_cond_wait( &(scdl->cv), &(scdl->lock) );
}

/*---------------------------------------------------------------------*/
/*    void                                                             */
/*    bglasync_scheduler_notify ...                                    */
/*    -------------------------------------------------------------    */
/*    This function must always be called within the dynamic           */
/*    extent of a bglasync_synchronize                                 */
/*---------------------------------------------------------------------*/
void
bglasync_scheduler_notify( bglthread_t scdl ) {
   pthread_cond_signal( &(scdl->cv) );
}

/*---------------------------------------------------------------------*/
/*    void                                                             */
/*    bglasync_synchronize ...                                         */
/*---------------------------------------------------------------------*/
void
bglasync_synchronize( bglthread_t scdl ) {
   pthread_mutex_lock( &(scdl->lock) );
}   

/*---------------------------------------------------------------------*/
/*    void                                                             */
/*    bglasync_asynchronize ...                                        */
/*---------------------------------------------------------------------*/
void
bglasync_asynchronize( bglthread_t scdl ) {
   pthread_mutex_unlock( &(scdl->lock) );
}


