/*
 * Copyright 2002 Murray Cumming
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef BAKERY_GNOMEUI_CONFIGURATION_CLIENT_H
#define BAKERY_GNOMEUI_CONFIGURATION_CLIENT_H

#include "bakery/Configuration/Client.h"
#include <libgnomeuimm.h>

namespace Bakery
{

namespace Conf
{

/** GnomeUI Configuration Client
 * Allows you to associate widget "values" with configuration keys,
 * and then load() and save() them all at once.
 * The "value" depends on the widget:
 *    Gnome::UI::ColorPicker - color name (gconf string).
 *    Gnome::UI::FontPicker - font name (gconf string).
 *    Gnome::UI::FileEntry - file path (gconf string).
 *    Gnome::UI::Entry - selected entry (gconf string).
 */

class Client_GnomeUI : public Client
{
public:
  Client_GnomeUI(const Glib::ustring& configuration_directory);
  virtual ~Client_GnomeUI();

protected:
  /// Override this method if you want to add recognition of additional
  /// widget types to a derived class of ConfClient. You will also need
  /// to provide an implementation for the specialization of Association<T>
  /// for the widget type(s) you are adding support for.
  ///
  virtual void add_implementation(const Glib::ustring& key, Gtk::Widget& widget,bool instant);

};

} //namespace Conf

} //namespace Bakery

#endif //BAKERY_GNOMEUI_CONFIGURATION_CLIENT_H
