/*
 * Decompiled with CFR 0.152.
 */
package nz.net.catalyst.lucene.testclient;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.UnknownHostException;

public class QueryTest {
    public static void main(String[] args) throws Exception {
        long tStart = System.currentTimeMillis();
        long tOpenedConnection = 9999L;
        long tAfterExecuting = 9999L;
        long tClosedConnection = 9999L;
        Socket echoSocket = null;
        PrintWriter out = null;
        BufferedReader in = null;
        try {
            echoSocket = new Socket("localhost", 22222);
            out = new PrintWriter(echoSocket.getOutputStream(), true);
            in = new BufferedReader(new InputStreamReader(echoSocket.getInputStream()));
        }
        catch (UnknownHostException e) {
            System.err.println("Don't know about host: localhost.");
            System.exit(1);
        }
        catch (IOException e) {
            System.err.println("Couldn't get I/O for the connection to: localhost.");
            System.exit(1);
        }
        tOpenedConnection = System.currentTimeMillis();
        String query = "QUERY\nApplication: sos\nQuery: Details:egypt\nQuery: Name:mouse\nReturn: Id Name\nQuery: Location:10 13\nRange-Field: DisplayStartDate\nRange-From: 2002-01-01\nRange-To: 2002-03-01\nQuery: Cancelled:N\nLimit: 5\nEND\n";
        String[] queries = new String[]{"QUERY\nApplication: sos\nRange-Field: DisplayStartDate\nRange-From: 2002-01-10\nRange-To: 2003-10-10\nQuery: (Name:super) OR (Teaser:super) OR (Details:super) AND (Cancelled:N)\nLimit: 5\nEND", "QUERY\nApplication: sos\nQuery: \nQuery: Domain:sos\nLimit: 5\nEND"};
        int i = 0;
        while (i < queries.length) {
            System.out.println("================= QUERY (" + i + ") ==================================");
            System.out.println(queries[i]);
            QueryTest.doCount(queries[i], out, in);
            System.out.print("Timings: ");
            long total = 0L;
            int j = 0;
            while (j < 10) {
                long time = QueryTest.doQuery(queries[i], out, in);
                System.out.print("\t" + time + "ms");
                total += time;
                ++j;
            }
            System.out.println("");
            System.out.println("Average time: " + total / 10L + "ms");
            ++i;
        }
        tAfterExecuting = System.currentTimeMillis();
        out.close();
        in.close();
        echoSocket.close();
        tClosedConnection = System.currentTimeMillis();
        System.out.println("program has completed successfully");
        System.out.println("================= Time Statistics =================");
        System.out.println(" Opening Connection: " + (tOpenedConnection - tStart));
        System.out.println(" Executing:          " + (tAfterExecuting - tOpenedConnection));
        System.out.println(" Closing Connection: " + (tClosedConnection - tAfterExecuting));
        System.out.println("===================================================");
    }

    static long doQuery(String command, PrintWriter out, BufferedReader in) throws Exception {
        String serverOutput;
        long tBefore = System.currentTimeMillis();
        out.println(command);
        BufferedReader br = new BufferedReader(in);
        while ((serverOutput = br.readLine()) != null && !serverOutput.startsWith("END")) {
        }
        long tAfter = System.currentTimeMillis();
        return tAfter - tBefore;
    }

    static void doCount(String command, PrintWriter out, BufferedReader in) throws Exception {
        String serverOutput;
        long tBefore = System.currentTimeMillis();
        out.println(command);
        BufferedReader br = new BufferedReader(in);
        while ((serverOutput = br.readLine()) != null && !serverOutput.startsWith("END")) {
            if (!serverOutput.startsWith("Count:")) continue;
            System.out.println("Total Result " + serverOutput);
        }
    }
}

