/****************************************************************
**
** Attal : Lords of Doom
**
** genericInsideBuilding.cpp
** describes building inside bases
**
** Version : $Id: genericInsideBuilding.cpp,v 1.5 2004/12/23 22:50:05 audoux Exp $
**
** Author(s) : Pascal Audoux
**
** Date : 04/01/2002
**
** Licence :    
**	This program is free software; you can redistribute it and/or modify
**   	it under the terms of the GNU General Public License as published by
**     	the Free Software Foundation; either version 2, or (at your option)
**      any later version.
**
**	This program is distributed in the hope that it will be useful,
** 	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
**
****************************************************************/

#include "genericInsideBuilding.h"
 
// generic include files
// include files for QT
// application specific include files
#include "libCommon/action.h"
#include "libCommon/dataTheme.h"


extern DataTheme DataTheme;
//
// ----- GenericInsideBuilding -----
//
GenericInsideBuilding::GenericInsideBuilding()
{
	_race = 0;
	_level = 0;
}

GenericInsideBuilding::~GenericInsideBuilding()
{

}

int GenericInsideBuilding::getX()
{
	return DataTheme.bases.at( _race )->getBuildingModel( _level )->getX();
}

int GenericInsideBuilding::getY()
{
	return DataTheme.bases.at( _race )->getBuildingModel( _level )->getY();
}

uint GenericInsideBuilding::getMantCost( uint ress )
{
	return DataTheme.bases.at( _race )->getBuildingModel( _level )->getMantCost( ress );
}

//
// ----- InsideBuildingModel -----
//

InsideBuildingModel::InsideBuildingModel()
{
	_race = 0;
	_level = 0;
	_name = "";
	_description = "";
	_x = 0;
	_y = 0;
	_replacement = -1;
	_require.setAutoDelete( true );
	_action = 0;
	for( int i = 0; i < MAX_RESS; i++ ) {
		_cost[i] = 0;
		_mcost[i] = 0;
	}
}

InsideBuildingModel::~InsideBuildingModel()
{
	if( _action ) {
		delete _action;
	}
}

void InsideBuildingModel::addRequirement( int req )
{
	int * item = new int( req );
	_require.append( item );
}

int InsideBuildingModel::getRequirement( int num )
{
	int ret = 0;
	if( (uint)num < _require.count() ) {
		ret =  * (_require.at( num ));
	}
	return ret;
}

uint InsideBuildingModel::getCost( uint ress )
{
	uint ret = 0;
	if( ress < DataTheme.resources.count() ) {
		ret = _cost[ress];
	}
	return ret;
}

void InsideBuildingModel::setCost( uint ress, uint cost )
{
	if( ress < DataTheme.resources.count() ) {
		_cost[ress] = cost;
	}
}

uint InsideBuildingModel::getMantCost( uint ress )
{
	uint ret = 0;
	if( ress < DataTheme.resources.count() ) {
		ret = _mcost[ress];
	}
	return ret;
}

void InsideBuildingModel::setMantCost( uint ress, uint cost )
{
	if( ress < DataTheme.resources.count() ) {
		_mcost[ress] = cost;
	}
}
