/*
 * Copyright (c) 2001,2002 Tony Sideris
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#ifndef __VCDDOC_H__
#define __VCDDOC_H__

#include "docwidget.h"
#include "processmgr.h"

class QToolButton;

/*==================================*/
/*	DEFINES
 *==================================*/

/*==================================*/
/*	CLASSES
 *==================================*/

class QListViewItem;

class ArsonVcdDoc : public ArsonFileListDoc
{
public:
	ArsonVcdDoc (QWidget *parent, const char *name = NULL);

	virtual void create (void);
	virtual void addItem (ArsonListItem *ptr, ArsonLvPos *pp);
	virtual ArsonProcessMgr *createCdWriter (ArsonProcessUI *pUI);
	virtual QString propDocType (void) const;

protected:
	virtual ArsonFileListItem *createFileItem (const KURL &url) const;
	virtual void buildFileFilter (ArsonFileFilter &filter);
	virtual ArsonProgress *createProgress (QWidget *parent);
	virtual ArsonListWnd *createListWnd (void);
};

/*========================================================*/

class ArsonVcdWriter : public ArsonCueWriter
{
public:
	ArsonVcdWriter (ArsonProcessUI *pUI, ArsonVcdDoc *pDoc);
	virtual ~ArsonVcdWriter (void);

	virtual void begin (const ArsonProcessOpts &opts);
	virtual void taskComplete (ArsonProcess *ptr);

	void setFileBase (const QString &filebase) { m_filebase = filebase; }
	
protected:
	QString m_filebase;
	ArsonVcdDoc *m_pDoc;
	bool m_bConverted;
};

/*========================================================*/
#endif	/*	__VCDDOC_H__	*/
