/*
 * Copyright (c) 2001,2002 Tony Sideris
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#ifndef __AUDIOFILE_H__
#define __AUDIOFILE_H__

/*========================================================*/

class ArsonAudioDecoderProcess;
class ArsonProcessMgr;

class ArsonAudioBase
{
public:
	ArsonAudioBase (const QString &path);
	virtual ~ArsonAudioBase (void) { }

	const QString &filename (void) const { return m_filename; }

	virtual ArsonAudioDecoderProcess *decoder(
		ArsonProcessMgr *pMgr, const char *outfile) { return NULL; }
	virtual QString title (void) { return QString(); }
	virtual QString decodedFile (void) = 0;
	virtual ulong length (void) = 0;
	virtual bool initialize (void) = 0;

private:
	QString m_filename;
};

/*========================================================*/

class ArsonFileFilter;

class ArsonAudioFile : public ArsonAudioBase
{
public:
	ArsonAudioFile (const QString &path);
	virtual ~ArsonAudioFile (void);

	virtual ArsonAudioDecoderProcess *decoder(
		ArsonProcessMgr *pMgr, const char *outfile);
	virtual QString title (void);
	virtual QString decodedFile (void);
	virtual ulong length (void);
	virtual bool initialize (void);

	static void audioFilter (ArsonFileFilter &filter);

private:
	enum {
		type_unknown = -1,
		type_mp3 = 0,
		type_wav,
#ifdef OGG
		type_ogg,
#endif	//	OGG

		type_shn,

#ifdef FLAC
		type_flac,
#endif
		_type_max,
	};

	ArsonAudioBase *m_pFile;
	int m_type;
};

/*========================================================*/
#endif	/*	__AUDIOFILE_H__	*/
