/***************************************************************************
 $RCSfile: aqmconverterdta.cpp,v $
                             -------------------
    cvs         : $Id: aqmconverterdta.cpp,v 1.2 2003/06/01 13:43:22 aquamaniac Exp $
    begin       : Sun May 18 2003
    copyright   : (C) 2003 by Werner Partner & Martin Preuss
    email       : martin@aquamaniac.de
*/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/


#include "aqmconverterdta.h"

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <list>
#include <string>
using namespace std;
using namespace HBCI;

#define MAXBUF 2048

#define DEZIMALTRNZ ','			/* Trennzeichen Komma		*/

char *strstrip (char *str);



AQMConverterDTA::AQMConverterDTA():AQMConverter() {
}


AQMConverterDTA::~AQMConverterDTA(){
}


HBCI::Error AQMConverterDTA::readFromStream(HBCI::Pointer<Stream> s) {
  short laenge;
  char satzart;
  char dy[64];
  char dyc;
  char dta_code[4];
  char dta_euro[16];
  char dta_typ[4];    	        /* GK oder LS - darf vermischt werden */
  double euro_wert;
  char t_waehrung;	        /* Whrungskennzeichen		*/
  unsigned x_anz_erw;
  unsigned anz_erw;
  char knz1[4], knz2[4], knz3[4], knz4[4];
  char vwz1[28], vwz2[28], vwz3[28], vwz4[28], vwz[28];


  char t_institute[255];     	/* eigene Bank			*/
  char t_id[32];		/* eigene Kontonummer		*/
  char t_otherinstitute[255];	/* andere Bank			*/
  char t_otherid[32];		/* andere Kontonummer		*/
  char t_value[32];		/* Wert: 11,22:EUR		*/
  char t_othername[64];		/* Empfnger			*/
  char t_description[255];	/* Text				*/
  char t_name[255];		/* eigener Name			*/
  HBCI::Transaction xa;
  int xatype;
  string data;
  int debugpos;

  xatype=0; // unknown
  fprintf(stderr, "Started to read.\n");
  debugpos=0;
  while (!s.ref().eof()) {
    fprintf(stderr,"Reading at %d\n", debugpos);

    data.erase();
    if (!s.ref().readRawForced(data, 5)) {
      return HBCI::Error("AQMConverterDTA::readFromStream",
			 ERROR_LEVEL_NORMAL,
			 0,
			 ERROR_ADVISE_DONTKNOW,
			 "read error");
    }

    fprintf (stderr, "%s\n", data.c_str());

    data[5] = '\0';
    satzart = data[4];

    data[4] = '\0';
    laenge = atoi(data.c_str());

    debugpos+=laenge;
    if (laenge > 0) {
      fprintf(stderr, "Satzlaenge is: %d\n", laenge);
      data.erase();

      /*          Jeder Satz hat eine Satzart:
       A: Kopfsatz
       C: Buchungsdaten
       E: Endesatz mit Kontrolldaten
       */

      switch (satzart) {     /* (dta_satztyp)*/
      case 'A':
	fprintf(stderr, "Have A set");
	//fprintf (stderr, "%s\n", data.c_str());

	if (!s.ref().readRawForced(data, laenge-5)) {
	  return HBCI::Error("AQMConverterDTA::readFromStream",
			     ERROR_LEVEL_NORMAL,
			     0,
			     ERROR_ADVISE_DONTKNOW,
			     "read error");
	}

	if (xatype!=0) {
	  return HBCI::Error("AQMConverterDTA::readFromFile",
			     ERROR_LEVEL_NORMAL,
			     0,
			     ERROR_ADVISE_DONTKNOW,
			     "mutliple A sets");
	}
	memset(t_institute, 0, sizeof(t_institute));
	memset(dta_typ, 0, sizeof(dta_typ));
	memset(t_name, 0, sizeof(t_name));
	memset(t_id, 0, sizeof(t_id));

	sscanf (data.c_str(), "%2c%8c%8c%27c%6c%4c%10c",
		dta_typ, t_institute, dy, t_name, dy, dy, t_id);


	if (dta_typ[0]=='G')
	  xatype=1; // transaction
	else if (dta_typ[0]=='L')
	  xatype=2; // Lastschrift
	else {
	  return HBCI::Error("AQMConverterDTA::readFromStream",
			     ERROR_LEVEL_NORMAL,
			     0,
			     ERROR_ADVISE_DONTKNOW,
			     "bad transaction type",
			     dta_typ);
	}
	break;

      case 'C':
	fprintf(stderr, "Have C set\n");
	if (!s.ref().readRawForced(data, 251)) {
	  return HBCI::Error("AQMConverterDTA::readFromStream",
			     ERROR_LEVEL_NORMAL,
			     0,
			     ERROR_ADVISE_DONTKNOW,
			     "read error");
	}

	memset(t_institute, 0, sizeof(t_institute));
	memset(t_otherinstitute, 0, sizeof(t_otherinstitute));
	memset(t_otherid, 0, sizeof(t_otherid));
	memset(dta_code, 0, sizeof(dta_code));
	memset(t_id, 0, sizeof(t_id));
	memset(t_othername, 0, sizeof(t_othername));
	memset(t_description, 0, sizeof(t_description));
	memset(t_value, 0, sizeof(t_value));
	t_waehrung = 0;
	sscanf (data.c_str(),
		"%8c%8c%10c%13c%2c%3c%c%11c%8c%10c%11c%3c%27c%8c%27c"
		"%27c%c%2c%2u%2c%27c%2c%27c",
		t_institute, t_otherinstitute, t_otherid, dy, dta_code, dy,
		&dyc, dy, t_institute, t_id, dta_euro, dy, t_othername, dy,
		dy, t_description, &t_waehrung, dy, &x_anz_erw, knz1, vwz1,
		knz2, vwz2);

	strncpy (t_value, dta_euro, 9);
	t_value[9] = '\0';
	euro_wert = atof (dta_euro) / 100;
	sprintf (t_value,"%.2f:EUR", euro_wert);
	t_value[strlen(t_value)-7] = DEZIMALTRNZ;


	/*
	 * Anzahl Erweiterungsstze errechnen und mit Angabe im
	 * Satz vergleichen
         */

	anz_erw = (laenge-187) / 29;
	if (anz_erw != x_anz_erw) {
	  return HBCI::Error("AQMConverterDTA::readFromStream",
			     ERROR_LEVEL_NORMAL,
			     0,
			     ERROR_ADVISE_DONTKNOW,
			     "DTA file corrupted");
	}

	// ****  Testausgabe

	fprintf (stderr, "# ----------------- C-Satz --------------------\n");
	fprintf (stderr, "# logische Lnge: %d\n", laenge);
	fprintf (stderr, "# gelesene Byte: 256\n");
	fprintf (stderr, "# Whrung: %c\n", t_waehrung);
	fprintf (stderr, "# Betrag: %s (%f)\n", t_value, euro_wert);
	fprintf (stderr, "# Anzahl Erweiterungsteile: %d (%d)\n", anz_erw,
		 x_anz_erw);
	fprintf (stderr, "# ---------------------------------------------\n");

	// ****  Testausgabe



	// transform to OpenHBCI data
	xa.setOurBankCode(t_institute);
	xa.setOurAccountId(t_id);
	xa.setOtherBankCode(t_otherinstitute);
	xa.setOtherAccountId(t_otherid);
	xa.setValue(HBCI::Value(t_value));
	xa.addOtherName(t_othername);
	xa.addDescription(t_description);


	// Weitere Ergnzungsstze

	if (strcmp (knz1, "02") == 0) {
	  vwz1[27] = '\0';
	  strcpy (vwz, (char *) strstrip(vwz1));
	  if (strlen (vwz) > 0) {
	    fprintf (stdout, "description=\"%s\"\n", vwz);
	    xa.addDescription(t_description);
	  }
	}

	if (strcmp (knz2, "02") == 0) {
	  vwz2[27] = '\0';
	  strcpy (vwz, (char *) strstrip(vwz2));
	  if (strlen (vwz) > 0) {
	    fprintf (stdout, "description=\"%s\"\n", vwz);
	    xa.addDescription(t_description);
	  }
	}

	/*
	 * -------------------------------------------------
	 * Die Erweiterungsstze 3-14 werden derzeit nur weggelesen,
	 * aber nicht ausgewertet
	 * Zur Zeit werden also nur 2 Verwendungszwecke ausgewertet und
	 * weitergegeben
	 * -------------------------------------------------
	 * Erweiterungssatz 3-6 vorhanden ?
	 */
	if (anz_erw > 2) {
	  if (!s.ref().readRawForced(data, 128)) {
	    return HBCI::Error("AQMConverterDTA::readFromStream",
			       ERROR_LEVEL_NORMAL,
			       0,
			       ERROR_ADVISE_DONTKNOW,
			       "read error");
	  }
	  memset(knz1, 0, sizeof(knz1));
	  memset(vwz1, 0, sizeof(vwz1));
	  memset(knz2, 0, sizeof(knz2));
	  memset(vwz2, 0, sizeof(vwz2));
	  memset(knz3, 0, sizeof(knz3));
	  memset(vwz3, 0, sizeof(vwz3));
	  memset(knz4, 0, sizeof(knz4));
	  memset(vwz4, 0, sizeof(vwz4));
	  sscanf (data.c_str(),"%2c%27c%2c%27c%2c%27c%2c%27c",
		  knz1, vwz1, knz2, vwz2, knz3, vwz3, knz4, vwz4);
	}

	/*
	 Erweiterungssatz 7-10 vorhanden ?
	 */
	if (anz_erw > 6) {
	  if (!s.ref().readRawForced(data, 128)) {
	    return HBCI::Error("AQMConverterDTA::readFromStream",
			       ERROR_LEVEL_NORMAL,
			       0,
			       ERROR_ADVISE_DONTKNOW,
			       "read error");
	  }
	  memset(knz1, 0, sizeof(knz1));
	  memset(vwz1, 0, sizeof(vwz1));
	  memset(knz2, 0, sizeof(knz2));
	  memset(vwz2, 0, sizeof(vwz2));
	  memset(knz3, 0, sizeof(knz3));
	  memset(vwz3, 0, sizeof(vwz3));
	  memset(knz4, 0, sizeof(knz4));
	  memset(vwz4, 0, sizeof(vwz4));
	  sscanf (data.c_str(),"%2c%27c%2c%27c%2c%27c%2c%27c",
		  knz1, vwz1, knz2, vwz2, knz3, vwz3, knz4, vwz4);
	}

	/*
	 * Erweiterungssatz 11-14 vorhanden ?
	 */
	if (anz_erw > 10) {
	  if (!s.ref().readRawForced(data, 128)) {
	    return HBCI::Error("AQMConverterDTA::readFromStream",
			       ERROR_LEVEL_NORMAL,
			       0,
			       ERROR_ADVISE_DONTKNOW,
			       "read error");
	  }
	  memset(knz1, 0, sizeof(knz1));
	  memset(vwz1, 0, sizeof(vwz1));
	  memset(knz2, 0, sizeof(knz2));
	  memset(vwz2, 0, sizeof(vwz2));
	  memset(knz3, 0, sizeof(knz3));
	  memset(vwz3, 0, sizeof(vwz3));
	  memset(knz4, 0, sizeof(knz4));
	  memset(vwz4, 0, sizeof(vwz4));
	  sscanf (data.c_str(),"%2c%27c%2c%27c%2c%27c%2c%27c",
		  knz1, vwz1, knz2, vwz2, knz3, vwz3, knz4, vwz4);
	}

	// ---  Ende Satzverarbeitung ---------------------------------------


	if (xatype==1)
	  xa.setTransactionCode(51); // normal transfer
	else if (xatype==2)
	  xa.setTransactionCode(5); // use 05 or 06 for debit
	addTransaction(xa);
	xatype=0; // unknown again

	xa=AQMTransaction();
	break;

      case 'E':
	fprintf(stderr, "Have E set\n");
	if (!s.ref().readRawForced(data, laenge-5)) {
	  return HBCI::Error("AQMConverterDTA::readFromStream",
			     ERROR_LEVEL_NORMAL,
			     0,
			     ERROR_ADVISE_DONTKNOW,
			     "read error");
	}

	break;

      default:
	fprintf(stderr, "Have this set: %c\n",data[0]);
	break;
      }
    }
  }
  if (xatype!=0) {
    fprintf(stderr, "Warning: A-set without data !\n");
  }

  return HBCI::Error();
}



/***************************************************************************
 *                                                                         *
 *   Diese Funktion wird eingefgt, bis klar ist, ob es im System          *
 *   eine andere bereits vorhandene Funktion gibt, die die gleiche         *
 *   Aufgabe erfllt                                                       *
 *                                                                         *
 ***************************************************************************/

static char *apu_strstrip=0;

char *strstrip (char *str){
  int i;

  if ((i=strlen(str)) == 0)
    return (str);
  if (apu_strstrip != 0)
    free (apu_strstrip);
  if ((apu_strstrip = (char *) malloc (i+1)) == 0)
    return (str);
  strcpy (apu_strstrip,str);
  for (;;)
    if ((apu_strstrip[--i] != ' ') || i<0)
      break;
  apu_strstrip[++i] = '\0';
  return (apu_strstrip);
}



