/***************************************************************************
 $RCSfile: aqminteractor.cpp,v $
                             -------------------
    cvs         : $Id: aqminteractor.cpp,v 1.12 2003/04/15 10:09:25 aquamaniac Exp $
    begin       : Tue Jul 16 2002
    copyright   : (C) 2002 by Martin Preuss
    email       : martin@aquamaniac.de
*/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif


#include <termios.h>
#include "aqminteractor.h"


AQMInteractor::AQMInteractor()
  :HBCI::Interactor()
{
}


AQMInteractor::~AQMInteractor(){
}

#define AQM_BUFSIZ 1024


bool AQMInteractor::_inputPin(string &pin, bool r) {
  HBCI::Pointer<HBCI::Bank> b;
  string msg;
  char buffer[AQM_BUFSIZ];
  struct termios OldAttr, NewAttr;
  int AttrChanged = 0;

  if (r)
    fprintf(stderr," Pin nochmal : ");
  else
    fprintf(stderr," Pin : ");

  // if possible, disable echo from stdin to stderr during password
  // entry

  if (0 == tcgetattr (fileno (stdin), &OldAttr))
    {
      NewAttr = OldAttr;
      NewAttr.c_lflag &= ~ECHO;
      tcsetattr (fileno (stdin), TCSAFLUSH, &NewAttr);
      AttrChanged = !0;
    }

  // FIXME: only show asterisks, don't use gets !
  fgets(buffer, AQM_BUFSIZ, stdin);

  // re-enable echo (if previously disabled)
  if (AttrChanged)
    tcsetattr (fileno (stdin), TCSADRAIN, &OldAttr);

  // Removes trailing \n, if it exists
  if (strlen(buffer)>0 && (buffer[strlen(buffer)-1] == '\n'))
    {
      buffer[strlen(buffer)-1] = '\0';

      // if the trailing \n hasn't been echoed...
      if (AttrChanged)
	putchar ('\n');
    }

  for (unsigned int i=0; i<AQM_BUFSIZ; i++)
    if (buffer[i]<32) {
      buffer[i]=0;
      break;
    }
  pin=buffer;

  // aborted ?
  if (pin.length()==0)
    return false;

  // done
  return true;
}



bool AQMInteractor::msgInputPin(HBCI::Pointer<HBCI::User> user,
                                string &pin,
                                int minsize,
                                bool newPin){
    HBCI::Pointer<HBCI::Bank> b;
    string msg;
    string lpin;
    bool pinOK;

    msg+=" Pin-Eingabe\n";
    msg+=" --------------------------------------------------------\007\n";
    msg+="  Sie koennen die Pin-Eingabe abbrechen, indem sie direkt\n";
    msg+="  ENTER druecken ohne die Pin einzugeben.\n";
    msg+="  Abgeschlossen wird die Pineingabe durch ENTER.\n";
    msg+=" --------------------------------------------------------\n";
    if (newPin)
      msg+=" Bitte geben Sie die neue Pin ein fuer ";
    else
      msg+=" Bitte geben Sie die derzeitige Pin ein fuer ";
    if (user.isValid()) {
      b=user.ref().bank();
      if (b.isValid()) {
	if (b.ref().name().empty())
	  msg+=b.ref().bankCode();
	else
	  msg+=b.ref().name();
      }
      else
	msg+="<unbekannte Bank>";
    } // if user is valid
    else
      msg+="<unbekannte Bank>";
    msg+=": ";
    fprintf(stderr,"%s\n",msg.c_str());

    pinOK=false;
    while(!pinOK) {
      if (!_inputPin(lpin, false)) {
	fprintf(stderr, "Pin-Eingabe abgebrochen.\n");
	return false;
      }
      if (lpin.length()<(unsigned int)minsize) {
	fprintf(stderr,
		" Pin muss mindestens %d Zeichen enthalten.\n",
		minsize);
      }
      if (newPin) {
	string llpin;
	if (!_inputPin(llpin, true)) {
	  fprintf(stderr, " PIN-Eingabe abgebrochen.\n");
	  return false;
	}
	if (lpin!=llpin) {
	  fprintf(stderr,
		  " PINs nicht identisch, bitte versuchen Sie es erneut.\n");
	}
	else
          pinOK=true;
      }
      else
        pinOK=true;
    } // while

    pin=lpin;

    // done
    return true;
}

void AQMInteractor::msgStartInputPinViaKeypad(Pointer<HBCI::User> user){
  HBCI::Pointer<HBCI::Bank> b;
  string msg;

  msg+=" \007Bitte geben Sie die Pin fuer ";
  if (user.isValid()) {
    b=user.ref().bank();
    if (b.isValid()) {
      if (b.ref().name().empty())
	msg+=b.ref().bankCode();
      else
	msg+=b.ref().name();
    }
    else
      msg+="<unbekannt Bank>";
  } // if user is valid
  else
    msg+="<unbekannte Bank>";
  msg+=" in die Tastatur des Kartenlesers ein:\n";
  fprintf(stderr,"%s",msg.c_str());
}


void AQMInteractor::msgFinishedInputPinViaKeypad(Pointer<HBCI::User> user){
  fprintf(stderr," Sichere Pineingabe beendet.\n");
}


bool
AQMInteractor::msgInsertMediumOrAbort(HBCI::Pointer<HBCI::User> user,
                                      MediumType t){
    HBCI::Pointer<HBCI::Bank> b;
    string msg;

    msg+=" Bitte Medium einlegen fuer ";
    if (user.isValid()) {
        b=user.ref().bank();
        if (b.isValid()) {
            if (b.ref().name().empty())
                msg+=b.ref().bankCode();
            else
                msg+=b.ref().name();
        }
        else
            msg+="<unbekannte Bank>";
    } // if user is valid
    else
        msg+="<unbekannte Bank>";
    msg+="\n";
    msg+=" <Bitte druecken Sie ENTER>\n";
    fprintf(stderr,"%s",msg.c_str());
    getchar();

    return true;
}


bool
AQMInteractor::msgInsertCorrectMediumOrAbort(HBCI::Pointer<HBCI::User> user,
                                             MediumType t){
    HBCI::Pointer<HBCI::Bank> b;
    string msg;

    msg+=" Bitte korrektes Medium einlegen fuer ";
    if (user.isValid()) {
        b=user.ref().bank();
        if (b.isValid()) {
            if (b.ref().name().empty())
                msg+=b.ref().bankCode();
            else
                msg+=b.ref().name();
        }
        else
            msg+="<unbekannte Bank>";
    } // if user is valid
    else
        msg+="<unbekannte Bank>";
    msg+="\n";
    msg+=" <Bitte druecken Sie ENTER>\n";
    fprintf(stderr,"%s",msg.c_str());
    getchar();

    return true;
}


void AQMInteractor::msgStateResponse(const string &msg){
  fprintf(stderr," Ergebnis: %s\n",msg.c_str());
}





