/* $Id: wmwindow.c,v 1.27 2000/10/31 02:47:35 komatsu Exp $ */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include "wmwindow.h"
#include "wmmain.h"
#include "wmresize.h"
#include "wmtitle.h"
#include "wmclose.h"
#include "wmiconify.h"
#include "wmbasewindow.h"
#include "wmdesign.h"
#include "wmchangabletitle.h"
#include "wmgroup.h"
#include "wmprop.h"
#include "wmmotif.h"

static GtkWidget* wm_window_border_widget(GtkWidget* client, gchar* name); 

void wm_window_border_release(WmClient *client)
{
   wm_message("WmWindow[%x]: wm_window_border_release\n",
	      WM_CLIENT_XWINDOW(client));

   /* Reparent 򤹤뤳Ȥˤ, Unmap Notify Զθˤʤ붲줢 */
   gdk_window_reparent(GTK_WIDGET(client)->window, GDK_ROOT_PARENT(),
		       WM_CLIENT_X(client), WM_CLIENT_Y(client));
}

/* Ѥεȥåȵǽ³ */
GtkWidget* wm_window_border_add(GtkWidget* client)
{
    GtkWidget 
	*vbox,
	*hbox, 
	*buttons,
	*window,  /* ȥåץ٥Υɥ  */
	*iconify, /* 󲽥ܥ          */
	*group,   /* 롼״              */
	*close,   /* ܥ            */
	*title,   /* ȥС              */
	*resize;  /* ꥵܥ            */

    wm_message("WmWindow: border_add\n");

    /* _MOTIF_WM_HINTS Ȥդ뤫Ƚ */
    if(wm_motif_prop_get_MWMHints(WM_CLIENT(client))) {
	window = wm_basewindow_new_default(client);
	gtk_container_border_width(GTK_CONTAINER(window), 0);
	gtk_container_add(GTK_CONTAINER(window), client);
	gtk_widget_show(client);
	return window;
    }

    vbox    = gtk_vbox_new(FALSE, 0);
    hbox    = gtk_hbox_new(FALSE, 0);

    /* -- ɥ ------------------------------------------------- */
    window = wm_basewindow_new_default(client);

    vbox = wm_window_border_widget(client, WM_CLIENT_BORDER_FRAME(client));
/*     vbox = wm_window_border_widget(client, WM_CLIENT(client)->border_frame); */
/*     vbox = wm_window_border_widget(client, "default"); */
    if(vbox == NULL) { /* դޤ Ad-hoc */
	wm_message("WmWindow: default window\n");
	/* -- 󲽥ܥ ------------------------------------------- */
	vbox    = gtk_vbox_new(FALSE, 0);
	buttons = gtk_hbox_new(FALSE, 0);
	iconify = wm_iconify_button_new_default(client);
	gtk_box_pack_start(GTK_BOX(buttons), iconify, FALSE, FALSE, 0);
	gtk_signal_connect(GTK_OBJECT(client), "iconify", 
			   GTK_SIGNAL_FUNC(wm_iconify_iconify_signal), 
			   NULL);
	gtk_widget_show(iconify);

	/* -- ܥ --------------------------------------------- */
	close = wm_close_button_new_default(client);
	gtk_box_pack_start(GTK_BOX(buttons), close, FALSE, FALSE, 0);
	gtk_widget_show(close);

	/* -- 롼״ܥ ----------------------------------------- */
	group = wm_group_button_new_default(client);
	gtk_box_pack_start(GTK_BOX(buttons), group, FALSE, FALSE, 0);
	gtk_widget_show(group);

	/* -- ȥС ----------------------------------------------- */
	title = wm_changable_title_button_new_default(client);
	gtk_box_pack_start(GTK_BOX(buttons), title,   TRUE,  TRUE,  0);
	gtk_widget_show(title);

	/* -- ꥵܥ --------------------------------------------- */
	resize = wm_resize_button_new_default(client);
	gtk_box_pack_end(GTK_BOX(hbox),  resize, TRUE, TRUE, 0);

	gtk_box_pack_start(GTK_BOX(vbox), buttons,    FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(vbox), client,  FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(vbox), hbox,   FALSE, FALSE, 0);

	gtk_widget_show(buttons);
	gtk_widget_show(client);
	gtk_widget_show(resize);
	gtk_widget_show(hbox);
    }

    gtk_widget_show(vbox);
    gtk_container_add(GTK_CONTAINER(window), vbox);
    return window;
}    

GtkWidget* wm_window_border_widget(GtkWidget* client, gchar* name) 
{
    GtkWidget *frame, *item;
    GList *list;

    WmRcFrame       *rc_frame;
    WmRcFrameWidget *rc_widget;

    wm_message("WmWindow: border_widget[%s]\n", name);

    rc_frame = wm_rc_frame_get(name);
    if (rc_frame == NULL) {
	return NULL;
    }

    switch (rc_frame->pack) {
    case RC_FRAME_PACK_V:
	frame = gtk_vbox_new(FALSE, 0);
	break;
    case RC_FRAME_PACK_H:
    default:
	frame = gtk_hbox_new(FALSE, 0);
    }
	
    for (list = rc_frame->widget; list; list = list->next) {
	rc_widget = list->data;
	/* ܥ󤫤ɤΥå⤹٤ */
	if (!strcmp(rc_widget->type, "button")) {
	    if (!strcmp(rc_widget->ref, "iconify")) {
		item = wm_iconify_button_new_default(client);
		gtk_box_pack_start(GTK_BOX(frame), item, FALSE, FALSE, 0);
		gtk_signal_connect(GTK_OBJECT(client), "iconify", 
				   GTK_SIGNAL_FUNC(wm_iconify_iconify_signal), 
				   NULL);
		gtk_widget_show(item);

	    } else if (!strcmp(rc_widget->ref, "close")) {
		item = wm_close_button_new_default(client);
		gtk_box_pack_start(GTK_BOX(frame), item, FALSE, FALSE, 0);
		gtk_widget_show(item);

	    } else if (!strcmp(rc_widget->ref, "group")) {
		item = wm_group_button_new_default(client);
		gtk_box_pack_start(GTK_BOX(frame), item, FALSE, FALSE, 0);
		gtk_widget_show(item);

	    } else if (!strcmp(rc_widget->ref, "ctitle")) {
		item = wm_changable_title_button_new_default(client);
		gtk_box_pack_start(GTK_BOX(frame), item,   TRUE,  TRUE,  0);
		gtk_widget_show(item);

	    } else if (!strcmp(rc_widget->ref, "title")) {
		item = wm_title_button_new_default(client);
		gtk_box_pack_start(GTK_BOX(frame), item,   TRUE,  TRUE,  0);
		gtk_widget_show(item);

	    } else if (!strcmp(rc_widget->ref, "resize")) {
		item = wm_resize_button_new_default(client);
		gtk_box_pack_start(GTK_BOX(frame), item,   TRUE,  TRUE,  0);
		gtk_widget_show(item);
	    }

	} else if(!strcmp(rc_widget->type, "client")) {
	    gtk_box_pack_start(GTK_BOX(frame), client, FALSE, FALSE, 0);
	    gtk_widget_show(client);

	} else if(!strcmp(rc_widget->type, "frame")) {
	    item = wm_window_border_widget(client, rc_widget->ref);
	    gtk_box_pack_start(GTK_BOX(frame), item, FALSE, FALSE, 0);
	    gtk_widget_show(item);
	}
    }
    return frame;
}

