#!/bin/sh
# Restart with tclsh\
exec tclsh "$0" "$@"

# This is example of simple ICQ client which only task is logging
# changes of status of contacts to standart input.

package require icq 0.8.6

proc Event {event args} {
	if {[llength [info commands ICQ::$event]]} { eval ICQ::$event $args } 
}

namespace eval ICQ {
	proc Status {uin status {ip ""}} {
		global cmd
		set now [clock format [clock seconds] -format {%x %X}]
		puts "$uin $status $now"
	}
}

# List of contacts to monitor their status
set contacts {47298730 161664730}

# Replace uin and password with real ones
set cmd [icq::icq 00000000 fake -port 1024 -event Event]
$cmd contacts all $contacts
$cmd status online
vwait z
