# Notifier module is used to display notifications and errors to user.
# Author: Igor Viarheichyk

option add *Notifier.text.height 8
option add *Notifier.text.width 50

proc Notifier {short message {report {}} {dump {}}} {
	variable notify
	set top .info[string map {. _ : _ " " _} $short]
	if {[winfo exists $top]} {
		raise $top
		$top.text configure -state normal
		$top.text delete 1.0 end
	} else {
		if {[info exists notify($short)] && $notify($short)} return
		toplevel $top -class Notifier
		wm title $top $short
		text $top.text -wrap word
		grid $top.text -sticky news -padx 10 -pady 10
		checkbutton $top.cb\
			-variable [namespace current]::notify($short)\
			-text [mc "Do not show this notification any more."]
		grid $top.cb -sticky w -padx 10
		if {$dump!=""} {
			checkbutton $top.dump\
				-variable [namespace current]::attach($short)\
				-text [mc "Attach packet dump to bugreport (can contain confidential information)"]
			grid $top.dump -sticky w -padx 10	
		}
		frame $top.btn -class Buttonbar
		grid $top.btn -sticky we -ipady 12 -ipadx 16 -padx 4 -pady 4
		if {$report!=""} {
			button $top.btn.send\
				-text [mc "Send bug report to author"]\
				-command [nc Send $top $short $report $dump]
			grid $top.btn.send -row 0 -column 1 -sticky w -padx 10
		}
		button $top.btn.close -text [mc Close]\
			-command [list destroy $top]
		bind $top <<Close>> [list $top.btn.close invoke]	
		grid $top.btn.close -row 0 -column 10 -sticky e -padx 10
		grid columnconfigure $top.btn 9 -weight 1
		foreach x {row column} {grid ${x}configure $top 0 -weight 1}
		bind $top <<Close>> [list $top.btn.close invoke]
	}
	focus $top
	$top.text insert end $message
	$top.text configure -state disabled
}

proc Send {top short report dump} {
	variable attach
	foreach x {Tcl BWidget alicq icq} { 
		set packages($x) "(not used)" 
		catch { set packages($x) [package present $x] }
	}
	append report "\n--- Info ---\nPlatform:"\
		[list [array get ::tcl_platform]] "\nEncoding:"\
		[encoding system] "\nPackages:" [list [array get packages]]
	append report "\n--- Stack ---\n$::errorInfo"
	if {$dump!="" && $attach($short)} {
		binary scan $dump H* dump
		append report "\n--- packet dump ---\n" $dump
	}
	set report "--- Automatical Bug Report ---\n$report"
	Event Send text Contact:ICQ:47298730 $report
	#Event Incoming text Contact:ICQ:47298730 [clock seconds] $report tte
	destroy $top
}

handler Error:Module Bugreporter {handler reason} {
	Notifier "[mc Error:] $handler"\
		"An error occured in event handler $handler:\n$reason.\n\nThe error is not fatal, you can continue work." "$reason in $handler"
}

handler Error:Protocol Bugreporter2 {handler reason dump args} {
	Notifier "ICQ library error in $handler"\
		"An error occured while processing ICQ protocol packet $handler:\n$reason\n\nThe error is not fatal and you can continue work. Please, send bug report to author." "$handler:\n$reason" $dump
}

handler Error ErrorNotify {code {description "Unknown error"}} {
	Notifier "[mc Error] $code" "$code\n[mc $description]"
}

handler Error:rate RateNotify {msg} {
	upvar #0 [pref "icq network reconnect"] reconnect
	if {[string is true $reconnect]} {
		append msg "\nAlicq will automatically re-connect in several minutes."
	}
	Notifier "Rate exceeded" "$msg"
}
handler Notify ShowInfo {title info} { Notifier $title $info }

