//==============================================
//  copyright            : (C) 2003-2005 by Will Stokes
//==============================================
//  This program is free software; you can redistribute it
//  and/or modify it under the terms of the GNU General
//  Public License as published by the Free Software
//  Foundation; either version 2 of the License, or
//  (at your option) any later version.
//==============================================

//Systemwide includes
#include <qfile.h>
#include <qtextstream.h>
#include <qstringlist.h>

#include <qtextbrowser.h>
#include <qpushbutton.h>
#include <qlayout.h>

#include <qkeysequence.h>

//Projectwide includes
#include "shortcuts.h"
#include "../../config.h"

//==============================================
Shortcuts::Shortcuts( QWidget* parent, const char* name ) : QDialog(parent,name)
{
  resize( 800, 550 );

  //--
  //Generate shortcuts HTML file
  
  //create/open xml file
  QFile* shortcutsFile = new QFile(TEMP_DIR + QString("/shortcuts.html") );;
  if(shortcutsFile->open(IO_WriteOnly))
  {
    //-----
    QTextStream stream( shortcutsFile );
    stream.setEncoding( QTextStream::Unicode );
    //-----
    stream << "<html><body>\n";   
    stream << "<table cellpadding='4'><tr>\n";
    stream << "  <td><img src='" << IMAGE_PATH << "miscImages/asHelpLogoSmall.png'></td>\n";
    stream << "  <td valign='middle'><font face='Arial, sans-serif' size='+3'>";
    stream << "<b>" << tr("Keyboard Shortcuts") << "</b></font></td>\n";
    stream << "</tr></table>\n";
    stream << "<p>\n";
    stream << "<font face='Arial, sans-serif'>\n";
    stream << "  <table width='100%' cellpadding='4' cellspacing='0'>\n";
    stream << "  <tr><td width='50%' bgcolor='lightgray'><b>" << tr("Action") << "</b></td>\n";
    stream << "  <td width='50%' bgcolor='lightgray'><b>" << tr("Shortcut") << "</b></td></tr>\n";
    stream << "  <!-- -------------------------------------------------- -->\n";
    stream << "  <tr><td colspan='2'><b><u>" << tr("Opening &amp; Saving") << "</u></b></td></tr>\n";
    stream << "  <tr><td>" << tr("New album") << "</td>\n";
    stream << "      <td>" << ((QString)QKeySequence(CTRL+Key_N)) << "</td></tr>\n";
    stream << "  <tr><td>" << tr("Open album") << "</td>\n";
    stream << "      <td>" << ((QString)QKeySequence(CTRL+Key_O)) << "</td></tr>\n";
    stream << "  <tr><td>" << tr("Open recent album") << "</td>\n";
    stream << "      <td>" << ((QString)QKeySequence(CTRL)) << "[" << 
                              ((QString)QKeySequence(Key_1)) << "-" <<
                              ((QString)QKeySequence(Key_9)) << "]" << "</td></tr>\n";
    stream << "  <tr><td>" << tr("Save album") << "</td>\n";
    stream << "      <td>" << ((QString)QKeySequence(CTRL+Key_S)) << "</td></tr>\n";
    stream << "  <tr><td>" << tr("Save album as") << "</td>\n";
    stream << "      <td>" << ((QString)QKeySequence(SHIFT+CTRL+Key_S)) << "</td></tr>\n";
    stream << "  <tr><td>" << tr("Quit") << "</td>\n";
    stream << "      <td>" << ((QString)QKeySequence(CTRL+Key_Q)) << "</td></tr>\n";
    stream << "  <!-- -------------------------------------------------- -->\n";
    stream << "  <tr><td colspan='2'><hr></td></tr>\n";
    stream << "  <tr><td colspan='2'><b><u>" << tr("Organizing") << "</u></b></td></tr>\n";
    stream << "  <tr><td>" << tr("Move to the first photo in the collection") << "</td>\n";
    stream << "      <td>" << ((QString)QKeySequence(Key_Home)) << "</td></tr>\n";
    stream << "  <tr><td>" << tr("Move to the last photo in the collection") << "</td>\n";
    stream << "      <td>" << ((QString)QKeySequence(Key_End)) << "</td></tr>\n";
    stream << "  <tr><td>" << tr("Select all photos") << "</td>\n";
    stream << "      <td>" << ((QString)QKeySequence(CTRL+Key_A)) << "</td></tr>\n";
    stream << "  <tr><td>" << tr("Deselect all photos") << "</td>\n";
    stream << "      <td>" << ((QString)QKeySequence(SHIFT+CTRL+Key_A)) << "</td></tr>\n";
    stream << "  <tr><td>" << tr("Rotate selected photos right") << "</td>\n";
    stream << "      <td>" << ((QString)QKeySequence(CTRL+Key_R)) << "</td></tr>\n";
    stream << "  <tr><td>" << tr("Rotate selected photos left") << "</td>\n";
    stream << "      <td>" << ((QString)QKeySequence(CTRL+Key_L)) << "</td></tr>\n";
    stream << "  <tr><td>" << tr("Delete selected photos") << "</td>\n";
    stream << "      <td>" << ((QString)QKeySequence(Key_Delete)) << "</td></tr>\n";
    stream << "  <tr><td>" << tr("Modify selected photo description") << "</td>\n";
    stream << "      <td>" << ((QString)QKeySequence(Key_Enter)) << "</td></tr>\n";
    stream << "  <tr><td>" << tr("Finish modifying selected photo description") << "</td>\n";
    stream << "      <td>" << ((QString)QKeySequence(Key_Escape)) << "</td></tr>\n";
    stream << "  <tr><td>" << tr("Edit first of selected photos") << "</td>\n";
    stream << "      <td>" << ((QString)QKeySequence(CTRL+Key_E)) << "</td></tr>\n";
    stream << "  <!-- -------------------------------------------------- -->\n";
    stream << "  <tr><td colspan='2'><hr></td></tr>\n";
    stream << "  <tr><td colspan='2'><b><u>Editing</u></b></td></tr>\n";
    stream << "  <tr><td>" << tr("Go to previous photo") << "</td>\n";
    stream << "      <td>" << ((QString)QKeySequence(Key_PageUp)) << "</td></tr>\n";
    stream << "  <tr><td>" << tr("Go to next photo") << "</td>\n";
    stream << "      <td>" << ((QString)QKeySequence(Key_PageDown)) << "</td></tr>\n";
    stream << "  <tr><td>" << tr("Go to first photo in the collection") << "</td>\n";
    stream << "      <td>" << ((QString)QKeySequence(Key_Home)) << "</td></tr>\n";
    stream << "  <tr><td>" << tr("Go to last photo in the collection") << "</td>\n";
    stream << "      <td>" << ((QString)QKeySequence(Key_End)) << "</td></tr>\n";
    stream << "  <tr><td>" << tr("Return to organizing") << "</td>\n";
    stream << "      <td>" << ((QString)QKeySequence(Key_Escape)) << "</td></tr>\n";
    stream << "  <!-- =-=-=-=-=-=-=-=-=-=-= -->\n";
    stream << "  <tr><td colspan='2'>&nbsp;</td></tr>\n";
    stream << "  <!-- =-=-=-=-=-=-=-=-=-=-= -->\n";
    stream << "  <tr><td>" << tr("Rotate photo left") << "</td>\n";
    stream << "      <td>" << ((QString)QKeySequence(CTRL+Key_L)) << "</td></tr>\n";
    stream << "  <tr><td>" << tr("Rotate photo right") << "</td>\n";
    stream << "      <td>" << ((QString)QKeySequence(CTRL+Key_R)) << "</td></tr>\n";
    stream << "  <tr><td>" << tr("Flip photo horizontally") << "</td>\n";
    stream << "      <td>" << ((QString)QKeySequence(CTRL+Key_F)) << "</td></tr>\n";
    stream << "  <tr><td>" << tr("Flip photo vertically") << "</td>\n";
    stream << "      <td>" << ((QString)QKeySequence(ALT+CTRL+Key_F)) << "</td></tr>\n";
    stream << "  <!-- =-=-=-=-=-=-=-=-=-=-= -->\n";
    stream << "  <tr><td colspan='2'>&nbsp;</td></tr>\n";
    stream << "  <!-- =-=-=-=-=-=-=-=-=-=-= -->\n";
    stream << "  <tr><td>" << tr("Select all") << "</td>\n";
    stream << "      <td>" << ((QString)QKeySequence(CTRL+Key_A)) << "</td></tr>\n";
    stream << "  <tr><td>" << tr("Deselect all") << "</td>\n";
    stream << "      <td>" << ((QString)QKeySequence(SHIFT+CTRL+Key_A)) << "</td></tr>\n";
    stream << "  <tr><td>" << tr("Nudge selection left") << "</td>\n";
    stream << "      <td>" << ((QString)QKeySequence(Key_Left)) << "</td></tr>\n";
    stream << "  <tr><td>" << tr("Nudge selection right") << "</td>\n";
    stream << "      <td>" << ((QString)QKeySequence(Key_Right)) << "</td></tr>\n";
    stream << "  <tr><td>" << tr("Nudge selection up") << "</td>\n";
    stream << "      <td>" << ((QString)QKeySequence(Key_Up)) << "</td></tr>\n";
    stream << "  <tr><td>" << tr("Nudge selection down") << "</td>\n";
    stream << "      <td>" << ((QString)QKeySequence(Key_Down)) << "</td></tr>\n";
    stream << "  <tr><td>" << tr("Expand selection") << "</td>\n";
    stream << "      <td>" << ((QString)QKeySequence(Key_Plus,Key_Equal)) << "</td></tr>\n";
    stream << "  <tr><td>" << tr("Shrink selection") << "</td>\n";
    stream << "      <td>" << ((QString)QKeySequence(Key_Minus,Key_Underscore)) << "</td></tr>\n";
    stream << "  <tr><td>" << tr("Resize selection") << "</td>\n";
    stream << "      <td>" << tr("Press and hold Shift, then Click and Drag Left / Right") << "</td></tr>\n";
    stream << "  <tr><td>" << tr("Rotate selection") << "</td>\n";
    stream << "      <td>" << (QString(tr("Press and hold %1, then Click selection"))
                                     .arg( ((QString)QKeySequence(CTRL)) )) << "</td></tr>\n";
    stream << "  <!-- -------------------------------------------------- -->\n";
    stream << "  <tr><td colspan='2'><hr></td></tr>\n";
    stream << "  <tr><td colspan='2'><b><u>" << tr("Levels and Grain Editors") << "</u></b></td></tr>\n";
    stream << "  <tr><td>" << tr("Show alternative") << "</td>\n";
    stream << "      <td>" << QString(tr("Hold %1")).arg( ((QString)QKeySequence(CTRL)) ) << "</td></tr>\n";
    stream << "  <tr><td>" << tr("Apply") << "</td>\n";
    stream << "      <td>" << ((QString)QKeySequence(Key_Enter)) << "</td></tr>\n";
    stream << "  <tr><td>" << tr("Cancel") << "</td>\n";
    stream << "      <td>" << ((QString)QKeySequence(Key_Escape)) << "</td></tr>\n";
    stream << "  <!-- -------------------------------------------------- -->\n";
    stream << "  <tr><td colspan='2'><hr></td></tr>\n";
    stream << "  <tr><td colspan='2'><b><u>" << tr("Miscellaneous") << "</u></b></td></tr>\n";
    stream << "  <tr><td>" << tr("View album statistics") << "</td>\n";
    stream << "      <td>" << ((QString)QKeySequence(CTRL+Key_I)) << "</td></tr>\n";
    stream << "  <tr><td>" << tr("Album Shaper help") << "</td>\n";
    stream << "      <td>" << ((QString)QKeySequence(CTRL+Key_Question)) << "</td></tr>\n";
    stream << "  <!-- -------------------------------------------------- -->\n";
    stream << "  </table>\n";
    stream << "</font>\n";
    stream << "</body></html>\n";
    shortcutsFile->close();
  }
  //--
  //set window title
  setCaption( tr("Album Shaper: Shortcuts"));
  //--
  //create shortcuts text browser
  QTextBrowser* content = new QTextBrowser( this );
  
  content->setHScrollBarMode( QScrollView::AlwaysOff );
  content->setVScrollBarMode( QScrollView::Auto );
  
//  content->setFrameStyle( QFrame::Panel | QFrame::Sunken );
  content->mimeSourceFactory()->setFilePath( QStringList(TEMP_DIR) );
  content->setSource( "shortcuts.html");
  //--
  //place handbook and close button in grid layout
  QGridLayout* grid = new QGridLayout( this, 2, 2, 0);
  grid->addMultiCellWidget( content, 0,0, 0,1 );
  grid->setColStretch( 0, 1 );
  grid->setRowStretch( 0, 1 );
  //--
  //PLATFORM_SPECIFIC_CODE - Close Button
#if (!defined(Q_OS_WIN) && !defined(Q_OS_MACX))
  QPushButton* closeButton = new QPushButton( tr("Close"), this );
  closeButton->setSizePolicy( QSizePolicy::Fixed, QSizePolicy::Fixed );
  closeButton->setDefault(true);
  connect( closeButton, SIGNAL(clicked()), SLOT(close()) );
  grid->addWidget( closeButton, 1, 0, Qt::AlignCenter );
#endif  
  //--
}
//==============================================
void Shortcuts::closeEvent( QCloseEvent* e)
{
  QWidget::closeEvent( e );
  emit closed();
}
//==============================================
void Shortcuts::reject()
{
  QDialog::reject();
  emit closed();
}
//==============================================
