//==============================================
//  copyright            : (C) 2003-2005 by Will Stokes
//==============================================
//  This program is free software; you can redistribute it
//  and/or modify it under the terms of the GNU General
//  Public License as published by the Free Software
//  Foundation; either version 2 of the License, or
//  (at your option) any later version.
//==============================================

#ifndef GUI_ALABEL_H
#define GUI_ALABEL_H

#define APPEAR_IMMEDIATELY 1
#define DISAPPEAR_IMMEDIATELY 2
#define SLIDE_IN_LEFT 3
#define SLIDE_OUT_LEFT 4
#define SLIDE_IN_RIGHT 5
#define SLIDE_OUT_RIGHT 6
#define FADE_TRANSITION 7

//--------------------
//forward declarations
class QTimer;
class QPixmap;
class QPainter;
class QImage;
class Action;
//--------------------

#include <qlabel.h>
#include <qpixmap.h>
#include <qdatetime.h>
#include <qmutex.h>

//=====================================
class ALabel : public QLabel
{
Q_OBJECT
//----------------------
public:
  ///create the label, optionally set a hover-over image (only displayed when pixmap for label is set and fully shown)
  ALabel( QWidget *parent=0, const char* name=0,
          QPixmap* hoverOverImage = NULL,
          int setMethod = APPEAR_IMMEDIATELY,
          int removalMethod = DISAPPEAR_IMMEDIATELY,
          int resetMethod = APPEAR_IMMEDIATELY,
          int removalBeforeResetMethod = DISAPPEAR_IMMEDIATELY,
          int initDelay = 130, int accel = 50);

   ///alter animation methods
   void setAnimationMethods(int setMethod = APPEAR_IMMEDIATELY,
                                              int removalMethod = DISAPPEAR_IMMEDIATELY,
                                              int resetMethod = APPEAR_IMMEDIATELY,
                                              int removalBeforeResetMethod = DISAPPEAR_IMMEDIATELY);

  ///animates setting an image
  void setPixmap ( const QPixmap &p );

  ///animates removing an image
  void removePixmap( bool forceImmediate = false);
protected:
  ///begin animating the pixmap
  void animatePixmap( );

  void drawContents( QPainter* p);

  void enterEvent( QEvent* e);
  void leaveEvent( QEvent* e);

  void mousePressEvent( QMouseEvent* );
  void mouseReleaseEvent( QMouseEvent* );
  void mouseDoubleClickEvent( QMouseEvent* );
  void mouseMoveEvent( QMouseEvent* );
//----------------------
signals:
  void dropEventOccured( QDropEvent* e);

  ///various mouse-click signals
  void mousePress();
  void mouseRelease();
  void mouseDoubleClick();

  void pixmapRemoved();
  //----------------------
private slots:
  void animate();
//----------------------
private:
  void internalRemovePixmap( bool forceImmediate = false );
  void internalSetPixmap ( const QPixmap &p );
  void appendJob(QPixmap* pix);
  void cleanStack();

  //actual and reset images
  QImage *pixStore, *resetPixStore;

  //method for removing old images when doing a set
  int setMethod;
  int removalMethod;
  int removalBeforeResetMethod;
  int resetMethod;

  //specs for ongoing animation
  int initDelay, accel, minDelay, delay, animationType;
  int step;

  //timer and time variables for ongoing animation
  QTimer* timer;
  QTime lastTime, currentTime;

  //should hover-over image be drawn on repaint?
  bool drawHoverOverImage;
  QRect hoverOverRect;

  //hover-overimage
  QPixmap* hoverOverImage;

  //is picture fully shown?
  bool imageShown;

  //is hand cursor shown?
  bool handCursorShown;

  //are we animating?
  bool animating;
  QMutex animatingBoolMutex;

  //are we preforming a reset action?
  bool resettingImage;

  //queue of actions
  Action* delayedActionHead;
  Action* delayedActionTail;
  QMutex queueMutex;
//----------------------
};
//======================


//======================
class Action
{
  public:
    Action(QPixmap* image);
    ~Action();
    Action* getNext();
    void setNext( Action* next);
    QPixmap* getImage();

  private:
    QPixmap* image;
    Action* next;
};
//======================


#endif //GUI_ALABEL_H
