//==============================================
//  copyright            : (C) 2003-2005 by Will Stokes
//==============================================
//  This program is free software; you can redistribute it
//  and/or modify it under the terms of the GNU General
//  Public License as published by the Free Software
//  Foundation; either version 2 of the License, or
//  (at your option) any later version.
//==============================================

#ifndef CONFIGURATION_CONFIGURATION_H
#define CONFIGURATION_CONFIGURATION_H

//--------------------
//forward declarations
class QString;
class SettingGroup;
//--------------------

//=====================================
/*! \brief Configuration object manages all user-specific application settings.
 */
//=====================================
class Configuration
{
//------------------------------------------------------
public:
  ///Constructs any necessary directories for loading and saving user settings, returns false if unsuccessful
  static bool constructSettingsDirectory();  

  ///Creates configuration variables using default values, then attempts to load settings from disk
  Configuration();

  ///Destructor saves settings to disk
  ~Configuration();
  //----------------------------
  ///Loads settings
  bool loadSettings();

  ///Saves settings
  bool saveSettings();

  ///Sets a setting value, if group does not exist it is created, if setting does not exist it is also created
  void setString( QString group, QString key, QString value);

    ///Set bool setting
  void setBool( QString group, QString key, bool val );

  ///Set int setting
  void setInt( QString group, QString key, int val );

  ///Fetch string setting
  QString getString(QString group, QString key);

  ///Fetch bool setting
  bool getBool(QString group, QString key);

  ///Fetch int setting
  int getInt(QString group, QString key);

  ///Fetch float setting
  float getFloat(QString group, QString key);

  ///Fetch double setting
  double getDouble(QString group, QString key);

  ///Resets a setting to it's default value
  void resetSetting(QString group, QString key);
  
  ///Removes an entire group of settings
  void removeGroup(QString group);  
  //------------------------------------------------------
private:
  ///Settings filename
  QString settingsFilename;
  
  ///pointer to first group
  SettingGroup* firstGroup;

  ///pointer to last group
  SettingGroup* lastGroup;

  ///pointer to currently selected group
  SettingGroup* curGroup;
//------------------------------------------------------
};
#endif //CONFIGURATION_CONFIGURATION_H
