<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<!-- ####################################### -->
<!-- ####################################### -->
<!-- Write slideshow html pages -->
<xsl:template match="album" mode="slideshows">
<xsl:for-each select="subalbum">
  <xsl:variable name="subalbumNumber" select="position()"/>
  <xsl:variable name="photoCount" select="count(photo)"/>
  <xsl:document method="html" indent="yes" href="{concat($outputPath, '/subalbum_', string(position()), '_slideshow.html')}"> 
    <html>
      <head>
        <meta name="generator" content="Album Shaper (c.) Will Stokes"/>
        <style type="text/css">
          &lt;!--
          
		a:link		{color:#0066ff;		text-decoration: none;		font-size:8pt}
		a:active	{color:#0066ff;		text-decoration: none;		font-size:8pt}
		a:visited	{color:#0066ff;		text-decoration: none;		font-size:8pt}
		a:hover 	{color:#ffffff; 	text-decoration: none; 		font-size:8pt}
        
        font.title{		font-size:			12pt;
						font-weight:		bold;
						text-transform:		uppercase;
						color:				#0066ff;
						letter-spacing:		5pt;	
						font-family:		"Times New Roman";}
		font.desc{		font-size:			8pt;
						font-weight:		normal;
						color:				#ffffff;
						font-family:		"Tahoma";}
		font.imgNum{	font-size:			8pt;
						font-weight:		bold;
						color:				#00ffff;
						font-family:		"Tahoma";}
		font.imgDesc{	font-size:			8pt;
						font-weight:		normal;
						color:				#00ffff;
						font-family:		"Arial";}
        font.credits{	color:				#aaaaaa;
						font-weight:		thin;
						font-style:			italic;
						font-size:			8pt;
						font-family:		"Times New Roman";
						background-color:	#222222}
	
				 
		div.titBox{		border-width:		0;
						background-color:	#000000;
						padding:			5px 5px 5px 5px;
						position:			absolute;
						left:				0;
						top:				0;}
		div.topNavBox{	border-width:		0;
						background-color:	#000000;
						padding:			5px 0px 5px 5px;
						position:			absolute;
						left:				0;
						top:				530;
						width:				610;}
		div.botNavBox{	border-width:		0;
						background-color:	#000000;
						padding:			3px;
						position:			absolute;
						left:				220;
						top:				716;}
		div.imgBox{		border-width:		0;
						background-color:	#000000;
						padding:			5px;
						position:			absolute;
						left:				0;
						top:				100;}
		div.imgDescBox{	border-width:		0;
						padding:			5px;
						background-color:	#000000;
						position:			absolute;
						left:				0;
						top:				594;
						width:				610;
						height:				100;}
		div.creditBox{	border-width:		0;
						background-color:	black;
						padding:			2px;
						position:			absolute;
						left:				243;
						top:				745;}
						
          --&gt;
        </style>
        <title><xsl:value-of select="name"/></title>
        <script type="text/javascript" language="JavaScript">
        <![CDATA[
        <!-- HIDE FROM OLD BROWSERS
        var imageNumber=1

        var photoTitles = new Array(]]><xsl:value-of select="count(photo)"/><![CDATA[);

        ]]>
        <xsl:for-each select="photo">
          <xsl:variable name="photoDescription" select="description"/>
          
          photoTitles[<xsl:value-of select="position()-1"/>] = <![CDATA["]]><xsl:call-template name="JavaScriptString">
                                      <xsl:with-param name="string" select="$photoDescription"/>
                                     </xsl:call-template><![CDATA["]]>;

        </xsl:for-each>
        <![CDATA[

        //######################################
        //Define functions used to change images
        //######################################
        function expandImage()
        {
          fileToOpen = "img/]]><xsl:value-of select="$subalbumNumber"/><![CDATA[/"+imageNumber+".jpg"
          new_window = window.open(fileToOpen,'albulmifyRules')
        }

        function reloadImage()
        {
			document.currentPhoto.src="img/]]><xsl:value-of select="$subalbumNumber"/><![CDATA[/"+imageNumber+"_slideshow.jpg"
			document.currentPhoto.alt=photoTitles[imageNumber-1];
//          document.photoInfo.whichPhoto.value="Photo " + imageNumber + " of ]]><xsl:value-of select="count(photo)"/><![CDATA["
			document.getElementById("photoNum").lastChild.nodeValue=imageNumber + " of ]]><xsl:value-of select="count(photo)"/><![CDATA["
			document.getElementById("photoDesc").lastChild.nodeValue=photoTitles[imageNumber-1];
        }

        function firstImage()
        {
          //set image number to first
          imageNumber = 1

          //reset image src value based on variable
          reloadImage()
        }

        function lastImage()
        {
          //set image number to last
          imageNumber = ]]><xsl:value-of select="count(photo)"/><![CDATA[

          //reset image src value based on variable
          reloadImage()
        }

        function nextImage()
        {
          //increment image number
          imageNumber = imageNumber + 1

          //wrap to begining if reached the end
          if (imageNumber==]]><xsl:value-of select="1 + count(photo)"/><![CDATA[)
          {imageNumber = 1}

          //reset image src value based on variable
          reloadImage()
        }

        function previousImage()
        {
          //decrement image number
          imageNumber = imageNumber - 1
          //wrap to begining if reached the end
          if (imageNumber==(1 - 1))
          {imageNumber = ]]><xsl:value-of select="count(photo)"/><![CDATA[}

          //reset image src value based on variable
          reloadImage()
        }
        -->
        ]]>
        
        
        
        
        
        
        
        
        </script>
      </head>
      <body bgcolor="#000000" text="#ffffff" background="resources/scanline.jpg">
      
      
		<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
		<!-- DISPLAY SUBALBUM NAME/DESC   -->
		<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
        <div class="titBox">
        <font class="title"><xsl:value-of select="name"/></font>
        <hr color="blue" width="600" align="left"/>
		<font class="desc"><xsl:value-of select="description"/></font>
		</div>
		<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
               
        
        <!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
		<!-- DISPLAY THE MAIN IMAGE       -->
		<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
		<div class="imgBox">
		
<!-- Disable expanding to large image in small web exports because they are not included! -->
<xsl:if test="$smallWebExport=0">
  <xsl:text disable-output-escaping="yes"><![CDATA[<a href="JavaScript:expandImage()">]]></xsl:text>
</xsl:if>

<img alt="current photo" src="img/{$subalbumNumber}/1_slideshow.jpg" name="currentPhoto" border="0"/>
		
<xsl:if test="$smallWebExport=0">
<xsl:text disable-output-escaping="yes"><![CDATA[</a>]]></xsl:text>
</xsl:if>
		
		</div>
		<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
		
		
        <!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
		<!-- DISPLAY NEXT/PREV BUTTONS    -->
		<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
		<div class="topNavBox">
		<center>
		<table border="0" cellpadding="0" cellspacing="0" width="100%">
		  <tr>
		    <td align="right">
				<a href="JavaScript:firstImage()"><img src="resources/first.jpg" alt="first" border="0"/></a>
		    </td>
		    <td align="right">
				<a href="JavaScript:previousImage()">	<img src="resources/prev.jpg"  alt="previous" border="0"/> </a>
			</td>
			<td valign="top" align="center" width="24%"> 
				<table background="resources/numPlate.jpg" border="0" cellpadding="0" cellspacing="0" width="80" height="30"><tr><td align="center">
				<font class="imgNum"><div id="photoNum">1 of <xsl:value-of select="$photoCount"/></div></font>
				</td></tr></table>
			</td>
			<td align="left">
				<a href="JavaScript:nextImage()"> <img src="resources/next.jpg" alt="next" border="0"/> </a>
			</td>
			<td>
				<a href="JavaScript:lastImage()"> <img src="resources/last.jpg" alt="last" border="0"/> </a>
			</td>
		  </tr>
		</table>
		</center>
		</div>
		<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
		
		
		<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
		<!-- DISPLAY PHOTO DESCRIPTION    -->
		<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
		<div class="imgDescBox">
		<table border="0" color="blue" cellpadding="5" cellspacing="0">
		  <tr>
		    <td>
				<font class="imgDesc"><div id="photoDesc"><xsl:value-of select="photo/description"/></div></font>
		    </td>
		  </tr>
		</table>
		</div>
		<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->


		<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
		<!-- DISPLAY THUMBS/INDEX BUTTONS -->
		<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
        <div class="botNavBox">
        <table border="0" bgcolor="#00356A">
          <tr>
            <td width="80">
				<a href="subalbum_{position()}_thumbs.html">THUMBNAILS</a>
			</td>
			<td width="10"></td>
			<td width="80">
				<a href="Album.html">ALBUM INDEX</a>
			</td>
		  </tr>
		</table>
        </div>
        <!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->


		<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
		<!-- DISPLAY THE CREDITS          -->
		<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
		<div class="creditBox">
		<font class="credits">Generated by <a href="http://albumshaper.sourceforge.net">Album Shaper</a></font>
		</div>
		<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
		
        
      </body>
    </html>
  </xsl:document>
</xsl:for-each>
</xsl:template>
<!-- ####################################### -->
<!-- ####################################### -->

</xsl:stylesheet>
