#ifndef CalendarGroup_h
#define CalendarGroup_h

#include <Foundation/Foundation.h>

@class CalendarUser;
@class CalendarDomain;
@protocol CalendarEvent;
@protocol CalendarOwner;

@protocol CalendarGroup
- (NSString *) name;
- (CalendarUser *) owner;
- (id <CalendarEvent>) setCalendarEvent:(id <CalendarEvent>)event;
@end

@interface CalendarGroup:NSObject <CalendarOwner>
{
	NSString *_name;
	CalendarUser *__owner;
	NSMutableArray *_eventList;

	id _permissionMap; /* TODO */
}

+ (CalendarGroup *) calendarGroupWithName:(NSString *)name
									owner:(CalendarUser *)owner;

- (id) initWithName:(NSString *)name
			  owner:(CalendarUser *)owner;

- (CalendarDomain *) calendarDomain;

@end

@interface CalendarGroupManager:NSObject <CalendarGroup>
{
	CalendarGroup *_group;
	CalendarUser *_manager;
}

- (id) initWithCalendarGroup:(CalendarGroup *)group
		manageByCalendarUser:(CalendarUser *)manager;

@end

#endif
