// file      : CCF/IDL2/SemanticGraph/Sequence.cpp
// author    : Boris Kolpackov <boris@dre.vanderbilt.edu>
// cvs-id    : Sequence.cpp,v 1.2 2004/01/01 00:12:30 boris Exp

#include "CCF/IDL2/SemanticGraph/Sequence.hpp"

namespace CCF
{
  namespace IDL2
  {
    namespace SemanticGraph
    {
      using Introspection::TypeInfo;
      using Introspection::Access;
      
      // Sequence
      //
      //
      namespace
      {
        TypeInfo
        sequence_init_ ()
        {
          TypeInfo ti (typeid (Sequence));
          ti.add_base (Access::PUBLIC,
                       true,
                       TypeTemplateSpecialization::static_type_info ());
          return ti;
        }

        TypeInfo sequence_ (sequence_init_ ());
      }

      TypeInfo const& Sequence::
      static_type_info () { return sequence_; }


      // UnboundedSequence
      //
      //
      namespace
      {
        TypeInfo
        unbounded_sequence_init_ ()
        {
          TypeInfo ti (typeid (UnboundedSequence));
          ti.add_base (Access::PUBLIC, true, Sequence::static_type_info ());
          return ti;
        }

        TypeInfo unbounded_sequence_ (unbounded_sequence_init_ ());
      }

      TypeInfo const& UnboundedSequence::
      static_type_info () { return unbounded_sequence_; }
    }
  }
}
