/*
 * snes9express
 * extra.cc
 * Copyright  1998-2004  David Nordlund
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * For further details, please read the included COPYING file,
 * or go to http://www.gnu.org/copyleft/gpl.html
 */

#include <cstdlib>
#include <cstdio>
#include <string>
#include <time.h>
#include "extra.h"

s9x_Snapshot::s9x_Snapshot(fr_Notebook*parent):
s9x_Notepage(parent, "Snapshot"),
Desc(this, "If you took a snaphot during a game,\n"
     "you can resume playing from that spot"),
File(this, Name, "", "", false)
{
   SetGridSize(1, 2, true);

   Pack(Desc);

   File.AddLabel("Snapshot file:");
   File.Args << fr_CaseInsensitive << "-loadsnapshot";
   File.SetKeyStroke("Load: [F1-F10] / Save: Shift+[F1-F10]");
   File.SetTooltip("if you have a snes9x snapshot that you'd like to "
		   "load, specify it here.");
   Pack(File);
   addOption(File);

   AddListener(this);
}

void s9x_Snapshot::FilePopup()
{
   File.FilePopup();
}

void s9x_Snapshot::EventOccurred(fr_Event*e)
{
   if(e->Is(this, fr_MenuClick))
     FilePopup();
}

/* ############################# s9x_Extra ################################ */

s9x_Extra::s9x_Extra(fr_Notebook*parent):
s9x_Notepage(parent, "Extra"),
Desc(this, "Any snes9x options you want to use that\n"
     "aren't present in " PROG ", you can add here."),
Options(this, "Extra Options:", "", false)
{
   SetGridSize(1, 2, true);

   Pack(Desc);

   Options.SetTooltip("Add here any options not covered elsewhere in "
		      PROG);
   Pack(Options);
}

void s9x_Extra::SetToDefaults() {
   ArgStr = "";
   Options.SetText(ArgStr);
}

void s9x_Extra::SiftArgs(fr_ArgList& L) {
   int a, p;
   const char *S;

   ArgStr = "";
   p = L.CountArgs();
   for(a=0; a<p; a++) {
      if(!L.IsMarked(a)) {
	 S = L[a];
	 if((S)&&(S[0])) {
	    ArgStr += S;
	    ArgStr += ' ';
	 };
      };
   };
   Options.SetText(ArgStr);
}

void s9x_Extra::CompileArgs(fr_ArgList& L) {
   int i;
   const char *arg;

   if(Options.IsDefault())
     return;

   fr_ArgList Extras(Options.GetText().c_str());

   for(i=0; (arg=Extras[i]); i++)
     L << arg;
}

void s9x_Extra::EventOccurred(fr_Event*e) {
}

void s9x_RandomTip() {
#define EXCUSE(n, s) "Excuse for excessive game playing, #" n ":\n \"" s "\""
   int tipcount, t;
   static const char*Tips[] = {
	"If you are having trouble with a ROM that uses SuperFX,\n"
	"try setting the ROM Format to \"Interleaved 2\".",

	"If you would like to know the exact command snes9express\n"
	"is sending to snes9x, open the Profiler and pull the\n"
	"scroll-bar over to the right",

	"Using the Control or Shift keys, you can select multple\n"
	"profiles in the Profiler.  Pressing Apply will merge the\n"
	"the selected profiles.",

	"If you have a OpenGL supported video card,\n"
	"try using the OpenGL version of snes9x,\n"
	"by selecting it in the Preferences window.",

	EXCUSE("1", "I am trying to improve my hand-eye coordination."),
	EXCUSE("2", "This game sure helps my situation analysis skills."),
	EXCUSE("3", "Video games are a great way to exercise sharp reflexes,\n"
		"and shorten reaction and decision making times"),
	EXCUSE("4", "Game? No, I think this is some kind of\n"
		"computer virus that has taken over the screen.\n"
		"I've been trying to get rid of it all day."),

	"If you can think of any tips that should go here,\n"
	"please feel free to submit them to " SNES9EXPRESS_EMAIL,
	""
   };
   for(tipcount=0; Tips[tipcount][0]; tipcount++);
   srand(time(NULL));
   t = rand() % tipcount;
   fr_Mesg(Tips[t]);
#undef EXCUSE
}
