/***************************************************************************
                          taskinfoscreen.cpp  -  description
                             -------------------
    begin                : Sun Mar 17 2002
    copyright            : (C) 2002 by Sebastian Schildt
    email                : sebastian@frozenlight.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "taskinfoscreen.h"

//#include <iostream>

void TaskinfoScreen::paintScreen(QPainter *p, const setiparse& s, paintHelpers *ph) {
	ph->clearScreen(p);

	ph->drawMainHeader(p,"Task information");
	
	p->setFont(ph->mediumFont);

	p->setPen(QPen(ph->lcarsOrange,2));
	p->drawLine(20,400,1004,400);


/* START BAR */
	double comp = s.getProc()*100.0;

/*Since we have many pen switches, we pre init them */
	QPen pen1 = QPen(ph->lcarsOrange,3);
	QPen pen2 = QPen(ph->lcarsOrange,1);	
  QPen pen3 = QPen(ph->lcarsLila,1);	

	int pos=(int) (s.getProc()*964.0);
	
	QPointArray marker;
	p->setPen(pen1);
 	/*  _
   * |
   *  - */
	 //p->setPen(Qt::blue);
  p->drawLine(30,650,35,650);
	p->drawLine(30,650,30,700);
	p->drawLine(30,700,35,700);

	//p->setPen(ph->lcarsOrange);
  p->drawLine(30,675,964+30,675);

	/* _
 	 *  |
   * - */
	p->drawLine(30+964-5,650,964+30,650);
	p->drawLine(964+30  ,650,964+30,700);
	p->drawLine(964+30  ,700,964+25,700);

  /* 100,0% */
  p->setFont(ph->smallFont);
	p->setPen(ph->lcarsLila);
  p->drawText(33,720,"0%");
	p->drawText(970,720,"100%");
					
	double curr;
	int x1,x2;	
  bool endloop = false;
	QString running;	

  for (int i = 0; i <= 964; i++) {

		putWUData(p, s, ph, i);

		if (endloop) {
			if (i < 640) {usleep(200);} //Sleep for correct timing of text display
			continue;
		}

		curr = (100.0/964.0)*i;
			if (i==pos) {
      	curr=comp;
				endloop = true;
		}
			

		p->fillRect(29+i-5,649,12,52,Qt::black);

		
		if (curr > 90.1) {
      p->fillRect(30+i-120,680,120,25,Qt::black);
		}
		else {
    	p->fillRect(20+i+6,680,100,25,Qt::black);
    }
		p->setPen(pen1);
		x1 = i+24;
		x2 = i+36;
		if (x1 <  30) { x1 = 30; }
		if (x2 > 994) { x2 = 994; }
		p->drawLine(x1,675,x2,675);

		if (i < 10) { //Repaint begin
			 p->setPen(pen1);
       p->drawLine(30,650,35,650);
			 p->drawLine(30,650,30,700);
	     p->drawLine(30,700,35,700);
		}

		if ( i > 954 ) { //Repaint end
      p->setPen(pen1);
			p->drawLine(30+964-5,650,964+30,650);
			p->drawLine(964+30  ,650,964+30,700);
			p->drawLine(964+30  ,700,964+25,700);
		}


	/* _
   * \/ */
 	   marker.setPoints(8, \
               i+25,650 , i+35,650  ,\
               i+30,665 , i+30,685  ,\
               i+35,700 , i+25,700  ,\
               i+30,685 , i+30,665  );
			p->setPen(pen2);
			p->drawPolygon(marker);

			p->setPen(pen3);
			running.sprintf("%.3f %%",curr);
			p->setFont(ph->smallFont);
			if (curr >= 90.0) {
      	p->drawText(30+i-100,700,running);
			}
			else {
			  p->drawText(30+i+10,700,running);
		  }
    p->flush();
		usleep(200);
	}

/* END BAR *****************/
/*--------------------------*/

	p->setFont(ph->mediumFont);
	p->setPen(ph->lcarsOrange);



	usleep(800000);

  usleep(800000);
  usleep(800000);
  usleep(800000);

}

void TaskinfoScreen::putWUData(QPainter *p, const setiparse& s, paintHelpers *ph, int ind) {
	p->setFont(ph->mediumFont);
	if (ind == 40 || ind == 440) {
    p->setPen(ph->lcarsLila);
		ph->sound->playBeep1();
	}
	else {
  	p->setPen(ph->lcarsOrange);
	}
	QString stmp;
	double dtmp;
	int h, m, sec;
	switch(ind) {
		case 40:
      p->drawText(10,75,"User information");
			p->flush();
			break;
		case 120:
			ph->sound->playBeep2();
      stmp = "User name: ";
			stmp = stmp+s.getUserName().c_str();
			p->drawText(10,105,stmp);
 		  p->flush();
			break;
		case 160:
			ph->sound->playBeep2();
      stmp.sprintf("User ID: %i",s.getUserId());
			p->drawText(10,130,stmp);
  		p->flush();
			break;
		case 200:
			ph->sound->playBeep2();
      stmp = "User registered: ";
			stmp += s.getTimeRegistered().c_str();
			p->drawText(10,155,stmp);
  		p->flush();
			break;
		case 240:
			ph->sound->playBeep2();
    	stmp = "Transfermode: ";
			stmp += "automatic";
			p->drawText(10,180,stmp);
  		p->flush();
			break; 	
		case 280:
			ph->sound->playBeep2();
     	stmp = "Last result uploaded: ";
			stmp += s.getTimeLastResult().c_str();
			p->drawText(10,205,stmp);
  		p->flush();
			break;
		case 320:
			ph->sound->playBeep2();
      stmp.sprintf("Workunits completed so far: %i",s.getNrCompleted());
			p->drawText(10,230,stmp);
  		p->flush();
			break;
		case 360:
			ph->sound->playBeep2();
			h = int(s.getCpuTime()/3600.0);
			m = int(s.getCpuTime()/60.0)  % 60;
			sec = int(s.getCpuTime()/3600.0)  % 60;
			stmp.sprintf("Total CPU time used so far: %i h %i m %i s",h,m,sec);
 		 	p->drawText(10,255,stmp);
 			p->flush();
			break;
		case 440:
      p->drawText(10,440,"Workunit information");
			p->flush();
			break;
  	case 480:
			ph->sound->playBeep2();
			stmp = "Workunit name: ";
			stmp += s.getWu_name().c_str();
			p->drawText(10,470,stmp);
 		  p->flush();
      break;
		case 520:
			ph->sound->playBeep2();
			stmp = "Data stored in location: ";
			stmp += s.getSetiPath().c_str();
			p->drawText(10,495,stmp);
 		  p->flush();
      break;
		case 560:
			ph->sound->playBeep2();
      stmp.sprintf("Completed: %.3f %%",s.getProc()*100.0);
			p->drawText(10,520,stmp);
 			p->flush();
			break;
		case 600:
			ph->sound->playBeep2();
      dtmp = (s.getWuCpuTime()/s.getProc())-s.getWuCpuTime();
			h = int(dtmp/3600.0);
			m = int(dtmp/60.0)  % 60;
			stmp.sprintf("Remaining time %i h %i m",h,m);
			p->drawText(10,545,stmp);
  		p->flush();
			break;
		case 640:
			ph->sound->playBeep2();
      dtmp = (s.getProc()*100.0)/(s.getWuCpuTime()/3600.0);
  		stmp.sprintf("%% / CPU hour %.3f",dtmp);
			p->drawText(10,570,stmp);
  		p->flush();
			break;
		default:
			break;
	}

}
