package com.clarkware.junitperf;

import java.util.Random;

/**
 * The <code>RandomTimer</code> is a <code>Timer</code>
 * with a random delay and a uniformly distributed variation.
 * 
 * @author <a href="mailto:mike@clarkware.com">Mike Clark</a>
 * @author <a href="http://www.clarkware.com">Clarkware Consulting, Inc.</a>
 * 
 * @see com.clarkware.junitperf.Timer
 */

public class RandomTimer implements Timer {

    private final Random _random;
    private final long _delay;
    private final double _variation;

	/**
	 * Constructs a <code>RandomTimer</code> with the
	 * specified minimum delay and variation.
	 *
	 * @param delay Minimum delay (ms).
	 * @param variation Variation (ms).
	 */
    public RandomTimer(long delay, double variation) {
		_delay = delay;	
		_variation = variation;
        _random = new Random();
    }

	/**
	 * Returns the timer delay.
	 *
	 * @return Delay (ms).
	 */
    public long getDelay() {
        return (long) Math.abs((_random.nextDouble() * _variation) + _delay);
    }
}
