/*
 * HPTalx
 * A PC<->HP48/49 communication program for Linux
 *
 * (C) 1999 by Bruno Barberi Gnecco
 *
 * rev 0.0.1: Initial testing
 */

/*
    Copyright note:

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <gtk/gtk.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "gui_utils.h"

/* a popup window, with a title, a message and an OK button. Rest of processing
will be frozen until OK is pressed. */
void message_box ( char *title, char *message ) {
	GtkWidget *dialog;
	GtkWidget *label;
	GtkWidget *button;

	dialog = gtk_dialog_new();

	/* 'freeze' */
	gtk_window_set_modal(GTK_WINDOW(dialog), TRUE);

	gtk_window_set_title (GTK_WINDOW(dialog), title);
	gtk_container_set_border_width (GTK_CONTAINER (dialog), 5);
	gtk_widget_set_usize(dialog, 0, 0);

	label = gtk_label_new(message);
	gtk_box_pack_start(GTK_BOX (GTK_DIALOG (dialog)->vbox), label,
			FALSE, FALSE, 10);
	gtk_widget_show(label);

	button = gtk_button_new_with_label("OK");
	gtk_signal_connect_object(GTK_OBJECT(button), "clicked",
	        	GTK_SIGNAL_FUNC(gtk_main_quit), GTK_OBJECT(dialog));
	gtk_signal_connect_object(GTK_OBJECT (button), "clicked",
			GTK_SIGNAL_FUNC(gtk_widget_destroy), GTK_OBJECT (dialog));
	gtk_box_pack_end(GTK_BOX (GTK_DIALOG (dialog)->action_area), button,
			FALSE, FALSE, 0);
	GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);
	gtk_widget_grab_default(button);
	gtk_widget_show(button);
	gtk_widget_show(dialog);

	gtk_main();
	return;
}

struct entry {
	char *text;
	GtkWidget *entry;
} ent;

static void set_text ( GtkWidget *w, gpointer data ) {
	if ( ent.text )
		free( ent.text );
	ent.text = strdup(gtk_entry_get_text(GTK_ENTRY(ent.entry)));
}

/* show an entry text window with title and message and returns the typed
text or NULL if cancel or no text was typed */
char *entry_popup ( char *title, char *message ) {
	GtkWidget *dialog;
	GtkWidget *label;
	GtkWidget *button;

	ent.text = NULL;
	dialog = gtk_dialog_new();

	/* 'freeze' */
	gtk_window_set_modal(GTK_WINDOW(dialog), TRUE);

	gtk_window_set_title (GTK_WINDOW(dialog), title );
	gtk_container_set_border_width (GTK_CONTAINER (dialog), 5);
	gtk_widget_set_usize(dialog, 0, 0);

	label = gtk_label_new(message);
	gtk_box_pack_start(GTK_BOX (GTK_DIALOG (dialog)->vbox), label,
			FALSE, FALSE, 10);
	gtk_widget_show(label);

	ent.entry = gtk_entry_new();
	gtk_box_pack_start(GTK_BOX (GTK_DIALOG (dialog)->vbox), ent.entry,
			FALSE, FALSE, 10);
	gtk_signal_connect(GTK_OBJECT (ent.entry), "activate",
			GTK_SIGNAL_FUNC(set_text), NULL );
	gtk_signal_connect_object(GTK_OBJECT (ent.entry), "activate",
	        	GTK_SIGNAL_FUNC(gtk_main_quit), GTK_OBJECT(dialog));
	gtk_signal_connect_object(GTK_OBJECT (ent.entry), "activate",
			GTK_SIGNAL_FUNC(gtk_widget_destroy), GTK_OBJECT (dialog));
	GTK_WIDGET_SET_FLAGS(ent.entry, GTK_CAN_DEFAULT);
	gtk_widget_grab_default(ent.entry);
	gtk_widget_show(ent.entry);

	button = gtk_button_new_with_label("OK");
	gtk_signal_connect_object(GTK_OBJECT (button), "clicked",
			GTK_SIGNAL_FUNC(set_text), NULL );
	gtk_signal_connect_object(GTK_OBJECT(button), "clicked",
	        	GTK_SIGNAL_FUNC(gtk_main_quit), GTK_OBJECT(dialog));
	gtk_signal_connect_object(GTK_OBJECT (button), "clicked",
			GTK_SIGNAL_FUNC(gtk_widget_destroy), GTK_OBJECT (dialog));
	gtk_box_pack_start(GTK_BOX (GTK_DIALOG (dialog)->action_area), button,
			FALSE, FALSE, 0);
	gtk_widget_show(button);
	button = gtk_button_new_with_label("Cancel");
	gtk_signal_connect_object(GTK_OBJECT(button), "clicked",
	        	GTK_SIGNAL_FUNC(gtk_main_quit), GTK_OBJECT(dialog));
	gtk_signal_connect_object(GTK_OBJECT (button), "clicked",
			GTK_SIGNAL_FUNC(gtk_widget_destroy), GTK_OBJECT (dialog));
	gtk_box_pack_start(GTK_BOX (GTK_DIALOG (dialog)->action_area), button,
			FALSE, FALSE, 0);
	gtk_widget_show(button);
	gtk_widget_show(dialog);

	gtk_main();
	return ent.text;
}

/* confirm popup. Opens a window with title and message, and two buttons, OK
and cancel. Returns OK or CANCEL */
RETVALUE value;

static void setok ( GtkWidget *w, gpointer data ) {
	value = OK;
}

static void setcancel ( GtkWidget *w, gpointer data ) {
	value = CANCEL;
}

RETVALUE confirm ( char *title, char *message ) {
	GtkWidget *dialog;
	GtkWidget *label;
	GtkWidget *button;

	dialog = gtk_dialog_new();

	/* 'freeze' */
	gtk_window_set_modal(GTK_WINDOW(dialog), TRUE);

	gtk_window_set_title (GTK_WINDOW(dialog), title);
	gtk_container_set_border_width (GTK_CONTAINER (dialog), 5);
	gtk_widget_set_usize(dialog, 0, 0);

	label = gtk_label_new(message);
	gtk_box_pack_start(GTK_BOX (GTK_DIALOG (dialog)->vbox), label,
			FALSE, FALSE, 10);
	gtk_widget_show(label);

	button = gtk_button_new_with_label("OK");
	gtk_signal_connect_object(GTK_OBJECT(button), "clicked",
	        	GTK_SIGNAL_FUNC(setok), NULL);
	gtk_signal_connect_object(GTK_OBJECT(button), "clicked",
	        	GTK_SIGNAL_FUNC(gtk_main_quit), GTK_OBJECT(dialog));
	gtk_signal_connect_object(GTK_OBJECT (button), "clicked",
			GTK_SIGNAL_FUNC(gtk_widget_destroy), GTK_OBJECT (dialog));
	gtk_box_pack_start(GTK_BOX (GTK_DIALOG (dialog)->action_area), button,
			FALSE, FALSE, 0);
	gtk_widget_show(button);
	button = gtk_button_new_with_label("Cancel");
	gtk_signal_connect_object(GTK_OBJECT(button), "clicked",
	        	GTK_SIGNAL_FUNC(setcancel), NULL);
	gtk_signal_connect_object(GTK_OBJECT(button), "clicked",
	        	GTK_SIGNAL_FUNC(gtk_main_quit), GTK_OBJECT(dialog));
	gtk_signal_connect_object(GTK_OBJECT (button), "clicked",
			GTK_SIGNAL_FUNC(gtk_widget_destroy), GTK_OBJECT (dialog));
	gtk_box_pack_end(GTK_BOX (GTK_DIALOG (dialog)->action_area), button,
			FALSE, FALSE, 0);
	GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);
	gtk_widget_grab_default(button);
	gtk_widget_show(button);
	gtk_widget_show(dialog);

	gtk_main();
	
	return value;
}
